/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.datatype.CodonTable;
import pal.datatype.CodonTableFactory;
import pal.datatype.Codons;
import pal.datatype.DataType;
import pal.math.OrthogonalHints;
import pal.misc.MutableDouble;
import pal.misc.PalObjectListener;
import pal.substmodel.CodonModel;
import pal.substmodel.SubstitutionModel;
import pal.util.XMLConstants;

public class YangCodonModel
extends CodonModel
implements Serializable,
XMLConstants {
    public static final double MAXIMUM_OMEGA = 100.0;
    public static final double MAXIMUM_KAPPA = 100.0;
    public static final double MINIMUM_OMEGA = 0.0;
    public static final double MINIMUM_KAPPA = 1.0E-6;
    public static final double DEFAULT_KAPPA = 2.0;
    public static final double DEFAULT_OMEGA = 1.0;
    public static final int KAPPA_PARAMETER = 0;
    public static final int OMEGA_PARAMETER = 1;
    private boolean showSE;
    private double kappa;
    private double omega;
    private double kappaSE;
    private double omegaSE;
    private byte[] rateMap;
    private CodonTable codonTable;
    private static final long serialVersionUID = -3955993899328983304L;
    private final double[] parameterStore_ = new double[2];

    public YangCodonModel(double omega, double kappa, double[] freq, CodonTable codonTable) {
        super(freq);
        this.kappa = kappa;
        this.omega = omega;
        this.codonTable = codonTable;
        this.setParameters(new double[]{kappa, omega});
        this.showSE = false;
    }

    public YangCodonModel(double omega, double kappa, double[] freq) {
        this(omega, kappa, freq, CodonTableFactory.createUniversalTranslator());
    }

    public YangCodonModel(double[] params, double[] freq) {
        this(params[0], params[1], freq, CodonTableFactory.createUniversalTranslator());
    }

    public YangCodonModel(double[] params, double[] freq, CodonTable codonTable) {
        this(params[0], params[1], freq, codonTable);
    }

    public int getModelID() {
        return 0;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: YANG (Yang, ????)");
        out.print("Parameter kappa: ");
        this.format.displayDecimal(out, this.kappa, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.kappaSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Parameter omega: ");
        this.format.displayDecimal(out, this.omega, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.omegaSE, 2);
            out.print(")");
        }
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
    }

    public int getNumParameters() {
        return 2;
    }

    public void setParameterSE(double paramSE, int n) {
        switch (n) {
            case 0: {
                this.kappaSE = paramSE;
                break;
            }
            case 1: {
                this.omegaSE = paramSE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.showSE = true;
    }

    public final double getKappaLowerLimit() {
        return 1.0E-6;
    }

    public final double getOmegaLowerLimit() {
        return 0.0;
    }

    public final double getKappaUpperLimit() {
        return 100.0;
    }

    public final double getOmegaUpperLimit() {
        return 100.0;
    }

    public final double getKappaDefaultValue() {
        return 2.0;
    }

    public final double getOmegaDefaultValue() {
        return 1.0;
    }

    public final double getOmega() {
        return this.omega;
    }

    public final double getKappa() {
        return this.kappa;
    }

    public final void setKappaSE(double value) {
        this.kappaSE = value;
    }

    public final void setOmegaSE(double value) {
        this.omegaSE = value;
    }

    public final void setKappa(double value) {
        this.setParameter(value, 0);
    }

    public final void setOmega(double value) {
        this.setParameter(value, 1);
    }

    public double getLowerLimit(int n) {
        return n == 0 ? 1.0E-6 : 0.0;
    }

    public double getUpperLimit(int n) {
        return n == 0 ? 100.0 : 100.0;
    }

    public double getDefaultValue(int n) {
        return n == 0 ? 2.0 : 1.0;
    }

    public String getParameterName(int i) {
        switch (i) {
            case 0: {
                return "kappa";
            }
            case 1: {
                return "omega";
            }
        }
        return "unknown";
    }

    public String getUniqueName() {
        return "Yang codon model";
    }

    protected void rebuildRateMatrix(double[][] rate, double[] parameters) {
        this.kappa = parameters[0];
        this.omega = parameters[1];
        int dimension = this.getDimension();
        int numRates = dimension * (dimension - 1) / 2;
        this.rateMap = new byte[numRates];
        int u = 0;
        while (u < dimension) {
            char[] codon1 = Codons.getNucleotidesFromCodonIndex(u);
            int v = u + 1;
            while (v < dimension) {
                char[] codon2 = Codons.getNucleotidesFromCodonIndex(v);
                int rateClass = -1;
                if (codon1[0] != codon2[0]) {
                    rateClass = codon1[0] == 'A' && codon2[0] == 'G' || codon1[0] == 'G' && codon2[0] == 'A' || codon1[0] == 'C' && codon2[0] == 'T' || codon1[0] == 'T' && codon2[0] == 'C' ? 1 : 2;
                }
                if (codon1[1] != codon2[1]) {
                    rateClass = rateClass == -1 ? (codon1[1] == 'A' && codon2[1] == 'G' || codon1[1] == 'G' && codon2[1] == 'A' || codon1[1] == 'C' && codon2[1] == 'T' || codon1[1] == 'T' && codon2[1] == 'C' ? 1 : 2) : 0;
                }
                if (codon1[2] != codon2[2]) {
                    rateClass = rateClass == -1 ? (codon1[2] == 'A' && codon2[2] == 'G' || codon1[2] == 'G' && codon2[2] == 'A' || codon1[2] == 'C' && codon2[2] == 'T' || codon1[2] == 'T' && codon2[2] == 'C' ? 1 : 2) : 0;
                }
                if (rateClass != 0) {
                    char aa1 = this.codonTable.getAminoAcidChar(codon1);
                    char aa2 = this.codonTable.getAminoAcidChar(codon2);
                    if (aa1 == '*' || aa2 == '*') {
                        rateClass = 0;
                    } else if (aa1 != aa2) {
                        rateClass += 2;
                    }
                }
                switch (rateClass) {
                    case 0: {
                        rate[u][v] = 0.0;
                        break;
                    }
                    case 1: {
                        rate[u][v] = this.kappa;
                        break;
                    }
                    case 2: {
                        rate[u][v] = 1.0;
                        break;
                    }
                    case 3: {
                        rate[u][v] = this.kappa * this.omega;
                        break;
                    }
                    case 4: {
                        rate[u][v] = this.omega;
                    }
                }
                rate[v][u] = rate[u][v];
                ++v;
            }
            rate[u][u] = 0.0;
            ++u;
        }
    }

    private final double setParametersIncomplete(double kappa, double omega) {
        this.parameterStore_[0] = kappa;
        this.parameterStore_[1] = omega;
        return this.setParametersNoScale(this.parameterStore_);
    }

    private final void finishSetParameters(double substitutionScale) {
        this.scale(substitutionScale);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.report(new PrintWriter(sw));
        return sw.toString();
    }

    public static final MutableDouble createKappaStore(double initialValue) {
        return YangCodonModel.createKappaStore(initialValue, "Kappa");
    }

    public static final MutableDouble createKappaStore(double initialValue, String name) {
        return new MutableDouble(initialValue, 2.0, 1.0E-6, 100.0, name);
    }

    public static final MutableDouble createOmegaStore(double initialValue) {
        return YangCodonModel.createOmegaStore(initialValue, "Omega");
    }

    public static final MutableDouble createOmegaStore(double initialValue, String name) {
        return new MutableDouble(initialValue, 1.0, 0.0, 100.0, name);
    }

    public static class SimpleNeutralSelection
    extends PalObjectListener.EventGenerator
    implements SubstitutionModel {
        public static final double P_UPPER_LIMIT = 1.0;
        public static final double P_LOWER_LIMIT = 0.0;
        public static final double P_DEFAULT_VALUE = 0.5;
        private YangCodonModel[] baseMatrixes_;
        private double p_ = 0.5;
        private double kappa_ = 2.0;
        private double[] probabilities_;
        private transient boolean needsRebuild_ = true;

        private SimpleNeutralSelection(SimpleNeutralSelection toCopy) {
            this.baseMatrixes_ = Utils.getCopy(toCopy.baseMatrixes_);
            this.p_ = toCopy.p_;
            this.kappa_ = toCopy.kappa_;
            this.probabilities_ = new double[2];
            this.scheduleRebuild();
        }

        public SimpleNeutralSelection(CodonTable translator, double[] codonProbabilities, double startingKappa) {
            this(translator, codonProbabilities, startingKappa, 0.5);
        }

        public SimpleNeutralSelection(CodonTable translator, double[] codonProbabilities, double startingKappa, double proportionZero) {
            this.probabilities_ = new double[2];
            this.p_ = proportionZero;
            this.baseMatrixes_ = new YangCodonModel[]{new YangCodonModel(0.0, startingKappa, codonProbabilities, translator), new YangCodonModel(1.0, startingKappa, codonProbabilities, translator)};
            this.kappa_ = startingKappa;
            this.scheduleRebuild();
        }

        private final void scheduleRebuild() {
            this.needsRebuild_ = true;
        }

        private final void check() {
            if (this.needsRebuild_) {
                this.rebuild();
                this.needsRebuild_ = false;
            }
        }

        private final void rebuild() {
            this.probabilities_[0] = this.p_;
            this.probabilities_[1] = 1.0 - this.p_;
            double x1 = this.baseMatrixes_[0].setParametersIncomplete(this.kappa_, 0.0);
            double x2 = this.baseMatrixes_[1].setParametersIncomplete(this.kappa_, 1.0);
            double scale = x1 * this.p_ + (1.0 - this.p_) * x2;
            this.baseMatrixes_[0].finishSetParameters(scale);
            this.baseMatrixes_[1].finishSetParameters(scale);
        }

        public Object clone() {
            return new SimpleNeutralSelection(this);
        }

        public double[] getEquilibriumFrequencies() {
            return this.baseMatrixes_[0].getEquilibriumFrequencies();
        }

        public SubstitutionModel getCopy() {
            return new SimpleNeutralSelection(this);
        }

        public double[] getEquilibriumProbabilities() {
            return this.probabilities_;
        }

        public DataType getDataType() {
            return this.baseMatrixes_[0].getDataType();
        }

        public int getNumberOfTransitionCategories() {
            return 2;
        }

        public double getTransitionCategoryProbability(int category) {
            this.check();
            return this.probabilities_[category];
        }

        public double[] getTransitionCategoryProbabilities() {
            this.check();
            return this.probabilities_;
        }

        public void getTransitionProbabilities(double branchLength, double[][][] tableStore) {
            this.check();
            this.baseMatrixes_[0].setDistance(branchLength);
            this.baseMatrixes_[0].getTransitionProbabilities(tableStore[0]);
            this.baseMatrixes_[1].setDistance(branchLength);
            this.baseMatrixes_[1].getTransitionProbabilities(tableStore[1]);
        }

        public void getTransitionProbabilities(double branchLength, int category, double[][] tableStore) {
            this.check();
            this.baseMatrixes_[category].setDistance(branchLength);
            this.baseMatrixes_[category].getTransitionProbabilities(tableStore);
        }

        public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] tableStore) {
            this.check();
            this.baseMatrixes_[0].setDistanceTranspose(branchLength);
            this.baseMatrixes_[0].getTransitionProbabilities(tableStore[0]);
            this.baseMatrixes_[1].setDistanceTranspose(branchLength);
            this.baseMatrixes_[1].getTransitionProbabilities(tableStore[1]);
        }

        public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] tableStore) {
            this.check();
            this.baseMatrixes_[category].setDistanceTranspose(branchLength);
            this.baseMatrixes_[category].getTransitionProbabilities(tableStore);
        }

        public int getNumParameters() {
            return 2;
        }

        public void setParameter(double param, int n) {
            if (n == 0) {
                this.kappa_ = param;
            } else {
                this.p_ = param;
            }
            this.scheduleRebuild();
            this.fireParametersChangedEvent();
        }

        public double getParameter(int n) {
            if (n == 0) {
                return this.kappa_;
            }
            return this.p_;
        }

        public void setParameterSE(double paramSE, int n) {
            System.out.println("Not implemented yet...");
        }

        public double getLowerLimit(int n) {
            if (n == 0) {
                return this.baseMatrixes_[0].getKappaLowerLimit();
            }
            return 0.0;
        }

        public double getUpperLimit(int n) {
            if (n == 0) {
                return this.baseMatrixes_[0].getKappaUpperLimit();
            }
            return 1.0;
        }

        public double getDefaultValue(int n) {
            if (n == 0) {
                return this.baseMatrixes_[0].getKappaUpperLimit();
            }
            return 0.5;
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }

        public String toString() {
            this.check();
            StringBuffer sb = new StringBuffer();
            sb.append("Simple Neutral Model [1]\n");
            sb.append("p0 = " + this.probabilities_[0] + "\n");
            sb.append("p1 = " + this.probabilities_[1] + "\n");
            sb.append("Kappa = " + this.kappa_ + "\n");
            sb.append("\n[1] Nielsen, R., Yang Z., 1998  Likelihood Models for Detecting Positively Selected Amino Acid Sites and Applications to the HIV-1 Envelope Gene. Genetics 148: 929-936.");
            return sb.toString();
        }

        public void report(PrintWriter pw) {
            pw.print(this.toString());
        }
    }

    public static class SimplePositiveSelection
    extends PalObjectListener.EventGenerator
    implements SubstitutionModel {
        private static final double MINIMUM_PROPORTION = 0.0;
        private static final double MAXIMUM_PROPORTION = 1.0;
        private YangCodonModel[] baseMatrixes_;
        private double p0_ = 0.5;
        private double p1_ = 0.5;
        private double p2_ = 0.5;
        private double[] probabilities_;
        private transient boolean needsRebuild_ = true;
        private double kappa_;
        private double freeOmega_;
        private static final long serialVersionUID = -7826700615445839100L;
        private static final int NUMBER_OF_CLASSES = 3;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(1);
            out.writeObject(this.baseMatrixes_);
            out.writeDouble(this.p0_);
            out.writeDouble(this.p1_);
            out.writeDouble(this.p2_);
            out.writeDouble(this.kappa_);
            out.writeDouble(this.freeOmega_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                default: 
            }
            this.probabilities_ = new double[3];
            this.baseMatrixes_ = (YangCodonModel[])in.readObject();
            this.p0_ = in.readDouble();
            this.p1_ = in.readDouble();
            this.p2_ = in.readDouble();
            this.kappa_ = in.readDouble();
            this.freeOmega_ = in.readDouble();
            this.scheduleRebuild();
        }

        protected SimplePositiveSelection(SimplePositiveSelection toCopy) {
            this.baseMatrixes_ = Utils.getCopy(toCopy.baseMatrixes_);
            this.probabilities_ = new double[3];
            this.p0_ = toCopy.p0_;
            this.p1_ = toCopy.p1_;
            this.freeOmega_ = toCopy.freeOmega_;
            this.kappa_ = toCopy.kappa_;
            this.scheduleRebuild();
        }

        public SimplePositiveSelection(CodonTable translator, double[] codonProbabilities, double startingKappa, double startingFreeOmega) {
            this(translator, codonProbabilities, startingKappa, startingFreeOmega, 0.5, 0.5, 0.5);
        }

        public SimplePositiveSelection(CodonTable translator, double[] codonProbabilities, double startingKappa, double startingFreeOmega, double p0, double p1) {
            this(translator, codonProbabilities, startingKappa, startingFreeOmega, p0, p1, 1.0 - p0 - p1);
        }

        public SimplePositiveSelection(CodonTable translator, double[] codonProbabilities, double startingKappa, double startingFreeOmega, double p0, double p1, double p2) {
            this.baseMatrixes_ = new YangCodonModel[3];
            this.probabilities_ = new double[3];
            this.setTransitionCategoryProbabilities(p0, p1, p2);
            this.kappa_ = startingKappa;
            this.freeOmega_ = startingFreeOmega;
            int i = 0;
            while (i < 3) {
                this.baseMatrixes_[i] = new YangCodonModel(1.0, 1.0, codonProbabilities, translator);
                ++i;
            }
            this.scheduleRebuild();
        }

        public Object clone() {
            return new SimplePositiveSelection(this);
        }

        public SubstitutionModel getCopy() {
            return new SimplePositiveSelection(this);
        }

        private final void scheduleRebuild() {
            this.needsRebuild_ = true;
        }

        private final void check() {
            if (this.needsRebuild_) {
                this.rebuild();
                this.needsRebuild_ = false;
            }
        }

        private final void rebuild() {
            double total = this.p0_ + this.p1_ + this.p2_;
            if (total == 0.0) {
                this.probabilities_[0] = 0.33;
                this.probabilities_[1] = 0.33;
                this.probabilities_[2] = 0.34;
            } else {
                this.probabilities_[0] = this.p0_ / total;
                this.probabilities_[1] = this.p1_ / total;
                this.probabilities_[2] = this.p2_ / total;
            }
            double x1 = this.baseMatrixes_[0].setParametersIncomplete(this.kappa_, 0.0);
            double x2 = this.baseMatrixes_[1].setParametersIncomplete(this.kappa_, 1.0);
            double x3 = this.baseMatrixes_[2].setParametersIncomplete(this.kappa_, this.freeOmega_);
            double scale = x1 * this.probabilities_[0] + this.probabilities_[1] * x2 + this.probabilities_[2] * x3;
            this.baseMatrixes_[0].finishSetParameters(scale);
            this.baseMatrixes_[1].finishSetParameters(scale);
            this.baseMatrixes_[2].finishSetParameters(scale);
        }

        public DataType getDataType() {
            return this.baseMatrixes_[0].getDataType();
        }

        public int getNumberOfTransitionCategories() {
            return 3;
        }

        public double getTransitionCategoryProbability(int category) {
            this.check();
            return this.probabilities_[category];
        }

        public double[] getTransitionCategoryProbabilities() {
            this.check();
            return this.probabilities_;
        }

        public double[] getEquilibriumFrequencies() {
            return this.baseMatrixes_[0].getEquilibriumFrequencies();
        }

        public void getTransitionProbabilities(double branchLength, double[][][] tableStore) {
            this.check();
            int i = 0;
            while (i < 3) {
                this.baseMatrixes_[i].setDistance(branchLength);
                this.baseMatrixes_[i].getTransitionProbabilities(tableStore[i]);
                ++i;
            }
        }

        public void getTransitionProbabilities(double branchLength, int category, double[][] tableStore) {
            this.check();
            this.baseMatrixes_[category].setDistance(branchLength);
            this.baseMatrixes_[category].getTransitionProbabilities(tableStore);
        }

        public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] tableStore) {
            this.check();
            int i = 0;
            while (i < 3) {
                this.baseMatrixes_[i].setDistanceTranspose(branchLength);
                this.baseMatrixes_[i].getTransitionProbabilities(tableStore[i]);
                ++i;
            }
        }

        public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] tableStore) {
            this.check();
            this.baseMatrixes_[category].setDistanceTranspose(branchLength);
            this.baseMatrixes_[category].getTransitionProbabilities(tableStore);
        }

        public final void setTransitionCategoryProbabilities(double p0, double p1, double p2) {
            this.p0_ = p0;
            this.p1_ = p1;
            this.p2_ = p2;
            this.scheduleRebuild();
        }

        public int getNumParameters() {
            return 5;
        }

        public void setParameter(double param, int n) {
            switch (n) {
                case 0: {
                    this.kappa_ = param;
                    break;
                }
                case 1: {
                    this.freeOmega_ = param;
                    break;
                }
                case 2: {
                    this.p0_ = param;
                    break;
                }
                case 3: {
                    this.p1_ = param;
                    break;
                }
                default: {
                    this.p2_ = param;
                }
            }
            this.scheduleRebuild();
            this.fireParametersChangedEvent();
        }

        public double getParameter(int n) {
            switch (n) {
                case 0: {
                    return this.kappa_;
                }
                case 1: {
                    return this.freeOmega_;
                }
                case 2: {
                    return this.p0_;
                }
                case 3: {
                    return this.p1_;
                }
            }
            return this.p2_;
        }

        public void setParameterSE(double paramSE, int n) {
            System.out.println("Not implemented yet...");
        }

        public double getLowerLimit(int n) {
            switch (n) {
                case 0: {
                    return 1.0E-6;
                }
                case 1: {
                    return 0.0;
                }
            }
            return 0.0;
        }

        public double getUpperLimit(int n) {
            switch (n) {
                case 0: {
                    return 100.0;
                }
                case 1: {
                    return 100.0;
                }
            }
            return 1.0;
        }

        public double getDefaultValue(int n) {
            switch (n) {
                case 0: {
                    return 2.0;
                }
                case 1: {
                    return 1.0;
                }
            }
            return 0.5;
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }

        public String toString() {
            this.check();
            StringBuffer sb = new StringBuffer();
            sb.append("Simple Positive Selection Model [1]\n");
            sb.append("p0 = " + this.probabilities_[0] + "\n");
            sb.append("p1 = " + this.probabilities_[1] + "\n");
            sb.append("p2 = " + this.probabilities_[2] + "\n");
            sb.append("Free Omega = " + this.freeOmega_ + "\n");
            sb.append("Kappa = " + this.kappa_ + "\n");
            sb.append("\n[1] Nielsen, R., Yang Z., 1998  Likelihood Models for Detecting Positively Selected Amino Acid Sites and Applications to the HIV-1 Envelope Gene. Genetics 148: 929-936.");
            return sb.toString();
        }

        public void report(PrintWriter pw) {
            pw.print(this.toString());
        }
    }

    public static final class Utils {
        public static final YangCodonModel[] getCopy(YangCodonModel[] toCopy) {
            if (toCopy == null) {
                return null;
            }
            YangCodonModel[] copy = new YangCodonModel[toCopy.length];
            int i = 0;
            while (i < copy.length) {
                copy[i] = (YangCodonModel)toCopy[i].clone();
                ++i;
            }
            return copy;
        }
    }
}

