/*
 * Decompiled with CFR 0.152.
 */
package pal.supgma;

import pal.coalescent.ConstantPopulation;
import pal.coalescent.DemographicModel;
import pal.misc.TimeOrderCharacterData;

public interface ThetaHandler {
    public int getNumberOfParameters(TimeOrderCharacterData var1);

    public void adjustDistances(double[][] var1, TimeOrderCharacterData var2);

    public boolean isCICompatible();

    public String getInfo();

    public void fillInLSInfo(double[] var1, int var2, int var3, int var4);

    public DemographicModel generateDemographicModel(double[] var1, double[] var2, TimeOrderCharacterData var3);

    public boolean canGenerateDemogrpahicModel();

    public static final class Utils {
        public static final ThetaHandler getSingleThetaHandler() {
            return SingleThetaHandler.INSTANCE;
        }

        public static final ThetaHandler getSingleThetaHandler(boolean isHaploid) {
            return isHaploid ? SingleThetaHandler.HAPLOID_INSTANCE : SingleThetaHandler.DIPLOID_INSTANCE;
        }

        public static final ThetaHandler getSetThetaHandler(double theta) {
            return new SetThetaHandler(theta);
        }

        public static final ThetaHandler getSetThetaHandler(double theta, boolean isHaploid) {
            SetThetaHandler sth = new SetThetaHandler(theta);
            sth.setPloidyNumber(isHaploid ? 2 : 4);
            return sth;
        }

        public static final ThetaHandler getOneThetaPerSampleHandler() {
            return OneThetaPerSampleHandler.INSTANCE;
        }

        private static final class OneThetaPerSampleHandler
        implements ThetaHandler {
            public static final ThetaHandler INSTANCE = new OneThetaPerSampleHandler();

            private OneThetaPerSampleHandler() {
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                return tocd.getSampleCount();
            }

            public boolean isCICompatible() {
                return false;
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample) {
                mRow[startingIndex + maxSample] = 1.0;
            }

            public DemographicModel generateDemographicModel(double[] deltas, double[] thetas, TimeOrderCharacterData tocd) {
                return null;
            }

            public boolean canGenerateDemogrpahicModel() {
                return false;
            }

            public String getInfo() {
                return "Multiple Theta";
            }
        }

        private static final class SetThetaHandler
        extends AbstractThetaHandler
        implements ThetaHandler {
            private double setTheta_;

            private SetThetaHandler(double theta) {
                this.setTheta_ = theta;
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                return 0;
            }

            public boolean isCICompatible() {
                return false;
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
                int numberOfTaxa = tocd.getIdCount();
                if (numberOfTaxa != matrix.length) {
                    throw new RuntimeException("Assertion error! Matrix doesn't look compatible with tocd as sizes different (" + matrix.length + ", " + numberOfTaxa + ")");
                }
                int i = 0;
                while (i < matrix.length) {
                    int j = 0;
                    while (j < matrix.length) {
                        if (i != j) {
                            double[] dArray = matrix[i];
                            int n = j;
                            dArray[n] = dArray[n] - this.setTheta_;
                        }
                        ++j;
                    }
                    ++i;
                }
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample) {
            }

            public DemographicModel generateDemographicModel(double[] deltas, double[] thetas, TimeOrderCharacterData tocd) {
                return new ConstantPopulation(this.setTheta_ / (double)this.getPloidyNumber(), 0);
            }

            public boolean canGenerateDemogrpahicModel() {
                return true;
            }

            public String getInfo() {
                return "Set Theta (" + this.setTheta_ + ", " + this.getPloidyType() + ")";
            }
        }

        private static final class SingleThetaHandler
        extends AbstractThetaHandler
        implements ThetaHandler {
            public static final ThetaHandler INSTANCE = new SingleThetaHandler();
            public static final ThetaHandler HAPLOID_INSTANCE = new SingleThetaHandler(2);
            public static final ThetaHandler DIPLOID_INSTANCE = new SingleThetaHandler(4);

            private SingleThetaHandler() {
            }

            private SingleThetaHandler(int ploidyNumber) {
                this.setPloidyNumber(ploidyNumber);
            }

            public final int getNumberOfParameters(TimeOrderCharacterData tocd) {
                return 1;
            }

            public void adjustDistances(double[][] matrix, TimeOrderCharacterData tocd) {
            }

            public boolean isCICompatible() {
                return true;
            }

            public void fillInLSInfo(double[] mRow, int startingIndex, int minSample, int maxSample) {
                mRow[startingIndex] = 1.0;
            }

            public DemographicModel generateDemographicModel(double[] deltas, double[] thetas, TimeOrderCharacterData tocd) {
                return new ConstantPopulation(thetas[0] / (double)this.getPloidyNumber(), 0);
            }

            public boolean canGenerateDemogrpahicModel() {
                return true;
            }

            public String getInfo() {
                return "Single Theta (" + this.getPloidyType() + ")";
            }
        }

        private static abstract class AbstractThetaHandler
        implements ThetaHandler {
            private int ploidyNumber_ = 2;
            public static final int HAPLOID_PLOIDY_NUMBER = 2;
            public static final int DIPLOID_PLOIDY_NUMBER = 4;

            private AbstractThetaHandler() {
            }

            public final void setPloidyNumber(int number) {
                this.ploidyNumber_ = number;
            }

            protected final int getPloidyNumber() {
                return this.ploidyNumber_;
            }

            protected final String getPloidyType() {
                return this.ploidyNumber_ == 2 ? "Haploid" : "Diploid";
            }
        }
    }
}

