/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import pal.misc.IdGroup;
import pal.tree.Node;
import pal.tree.SplitUtils;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class CladeSystem {
    private IdGroup idGroup;
    private boolean[][] clades;

    public CladeSystem(IdGroup idGroup, int size) {
        this.idGroup = idGroup;
        this.clades = new boolean[size][idGroup.getIdCount()];
    }

    public int getCladeCount() {
        return this.clades.length;
    }

    public int getLabelCount() {
        return this.clades[0].length;
    }

    public boolean[][] getCladeArray() {
        return this.clades;
    }

    public boolean[] getClade(int i) {
        return this.clades[i];
    }

    public IdGroup getIdGroup() {
        return this.idGroup;
    }

    public boolean hasClade(boolean[] clade) {
        int i = 0;
        while (i < this.clades.length) {
            if (SplitUtils.isSame(clade, this.clades[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int i = 0;
        while (i < this.getLabelCount()) {
            pw.println(this.idGroup.getIdentifier(i));
            ++i;
        }
        pw.println();
        int i2 = 0;
        while (i2 < this.getCladeCount()) {
            int j = 0;
            while (j < this.getLabelCount()) {
                if (this.clades[i2][j]) {
                    pw.print('*');
                } else {
                    pw.print('.');
                }
                ++j;
            }
            pw.println();
            ++i2;
        }
        return sw.toString();
    }

    public static CladeSystem[] getCladeSystems(Tree[] trees) {
        IdGroup idGroup = TreeUtils.getLeafIdGroup(trees[0]);
        CladeSystem[] cladeSystems = new CladeSystem[trees.length];
        int i = 0;
        while (i < cladeSystems.length) {
            cladeSystems[i] = CladeSystem.getClades(idGroup, trees[i]);
            ++i;
        }
        return cladeSystems;
    }

    public static void calculateCladeProbabilities(Tree tree, CladeSystem[] cladeSystems) {
        CladeSystem cladeSystem = CladeSystem.getClades(cladeSystems[0].getIdGroup(), tree);
        int i = 0;
        while (i < tree.getInternalNodeCount() - 1) {
            Node node = tree.getInternalNode(i);
            boolean[] clade = cladeSystem.getClade(i);
            if (node.isRoot()) {
                throw new RuntimeException("Root node does not have clade probability!");
            }
            int cladeCount = 0;
            int j = 0;
            while (j < cladeSystems.length) {
                if (cladeSystems[j].hasClade(clade)) {
                    ++cladeCount;
                }
                ++j;
            }
            double pr = (double)cladeCount / (double)cladeSystems.length;
            tree.setAttribute(node, "clade probability", new Double(pr));
            ++i;
        }
    }

    public static CladeSystem getClades(IdGroup idGroup, Tree tree) {
        tree.createNodeList();
        int size = tree.getInternalNodeCount() - 1;
        CladeSystem cladeSystem = new CladeSystem(idGroup, size);
        boolean[][] clades = cladeSystem.getCladeArray();
        int i = 0;
        while (i < size) {
            CladeSystem.getClade(idGroup, tree.getInternalNode(i), clades[i]);
            ++i;
        }
        return cladeSystem;
    }

    public static CladeSystem getClades(Tree tree) {
        IdGroup idGroup = TreeUtils.getLeafIdGroup(tree);
        return CladeSystem.getClades(idGroup, tree);
    }

    public static void getClade(IdGroup idGroup, Node internalNode, boolean[] clade) {
        if (internalNode.isLeaf() || internalNode.isRoot()) {
            throw new IllegalArgumentException("Only internal nodes (and no root) nodes allowed");
        }
        int i = 0;
        while (i < clade.length) {
            clade[i] = false;
            ++i;
        }
        SplitUtils.markNode(idGroup, internalNode, clade);
    }

    public static boolean isSame(boolean[] s1, boolean[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Clades must be of the same length!");
        }
        int i = 0;
        while (i < s1.length) {
            if (s1[i] != s2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

