/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.IOException;
import java.io.PushbackReader;
import pal.io.FormattedInput;
import pal.io.InputSource;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;
import pal.tree.TreeParseException;

public class ReadTree
extends SimpleTree {
    private FormattedInput fi = FormattedInput.getInstance();

    public ReadTree(PushbackReader input) throws TreeParseException {
        this.readNH(input);
        NodeUtils.lengths2Heights(this.getRoot());
        this.createNodeList();
    }

    public ReadTree(String file) throws TreeParseException, IOException {
        InputSource input = InputSource.openFile(file);
        this.readNH(input);
        input.close();
        NodeUtils.lengths2Heights(this.getRoot());
        this.createNodeList();
    }

    private void readNH(PushbackReader input, Node currentNode) throws TreeParseException {
        try {
            int c = this.fi.readNextChar(input);
            if (c == 40) {
                int count = 0;
                do {
                    Node newNode = NodeFactory.createNode();
                    currentNode.addChild(newNode);
                    this.readNH(input, newNode);
                    ++count;
                } while ((c = this.fi.readNextChar(input)) == 44);
                if (c != 41) {
                    throw new TreeParseException("Missing closing bracket");
                }
                if (count < 2) {
                    throw new TreeParseException("Node with single child enountered");
                }
            } else {
                input.unread(c);
            }
            currentNode.setIdentifier(new Identifier(this.fi.readLabel(input, -1)));
            c = this.fi.readNextChar(input);
            if (c == 58) {
                currentNode.setBranchLength(this.fi.readDouble(input, true));
            } else {
                input.unread(c);
            }
        }
        catch (IOException e) {
            throw new TreeParseException("IO error");
        }
        catch (NumberFormatException e) {
            throw new TreeParseException("Error while parsing number");
        }
    }

    private void readNH(PushbackReader input) throws TreeParseException {
        try {
            this.readNH(input, this.getRoot());
            int c = this.fi.readNextChar(input);
            if (c != 59) {
                throw new TreeParseException("Missing terminating semicolon");
            }
        }
        catch (IOException e) {
            throw new TreeParseException();
        }
    }
}

