/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.tree.Node;

public interface RootedTreeInterface {
    public RNode createRoot();

    public static final class Utils {
        private static final void create(Node palNode, RNode rNode) {
            int numberOfChildren = palNode.getChildCount();
            rNode.resetChildren();
            if (numberOfChildren == 0) {
                rNode.setLabel(palNode.getIdentifier().getName());
            } else {
                int i = 0;
                while (i < numberOfChildren) {
                    Node palChild = palNode.getChild(i);
                    RNode displayChild = rNode.createRChild();
                    RBranch b = displayChild.getParentRBranch();
                    b.setLength(palChild.getBranchLength());
                    Utils.create(palChild, displayChild);
                    ++i;
                }
            }
        }

        public static final void instruct(Node palRoot, RootedTreeInterface treeInterface) {
            Utils.create(palRoot, treeInterface.createRoot());
        }
    }

    public static interface RBranch {
        public void setLength(double var1);

        public void setAnnotation(Object var1);

        public RNode getMoreRecentNode();

        public RNode getLessRecentNode();
    }

    public static interface RNode {
        public RBranch getParentRBranch();

        public void setLabel(String var1);

        public void setAnnotation(Object var1);

        public void resetChildren();

        public RNode createRChild();
    }

    public static interface Instructee {
        public void instruct(RootedTreeInterface var1);
    }
}

