/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.SimpleTree;
import pal.tree.Tree;

public class TreeRestricter {
    private final RNode root_;
    private final int units_;

    public TreeRestricter(Node root, int units, String[] names, boolean inclusion) {
        this.root_ = this.construct(root, names, inclusion, true);
        this.units_ = units;
    }

    public TreeRestricter(Tree t, String[] names, boolean inclusion) {
        this(t.getRoot(), t.getUnits(), names, inclusion);
    }

    private static final boolean isAccept(String query, String[] names, boolean inclusion) {
        boolean found = false;
        int i = 0;
        while (i < names.length) {
            if (query.equals(names[i])) {
                found = true;
                break;
            }
            ++i;
        }
        if (inclusion) {
            return found;
        }
        return !found;
    }

    public final Node generateNode() {
        return this.root_.constructPAL();
    }

    public final Tree generateTree() {
        SimpleTree st = new SimpleTree(this.root_.constructPAL());
        st.setUnits(this.units_);
        return st;
    }

    public final RNode construct(Node peer, String[] names, boolean inclusion, boolean isRoot) {
        if (peer.isLeaf()) {
            String leafName = peer.getIdentifier().getName();
            if (TreeRestricter.isAccept(leafName, names, inclusion)) {
                return new LeafNode(leafName, peer.getBranchLength());
            }
            return null;
        }
        double branchLength = isRoot ? 0.0 : peer.getBranchLength();
        int childCount = peer.getChildCount();
        if (childCount == 2) {
            RNode left = this.construct(peer.getChild(0), names, inclusion, false);
            RNode right = this.construct(peer.getChild(1), names, inclusion, false);
            if (left == null) {
                if (right == null) {
                    return null;
                }
                if (isRoot) {
                    right.zeroBranchLength();
                } else {
                    right.increaseBranchLength(branchLength);
                }
                return right;
            }
            if (right == null) {
                if (isRoot) {
                    left.zeroBranchLength();
                } else {
                    left.increaseBranchLength(branchLength);
                }
                return left;
            }
            return new InternalNode(left, right, branchLength);
        }
        int numberOfChildrenFound = 0;
        RNode[] children = new RNode[childCount];
        int i = 0;
        while (i < childCount) {
            RNode c = this.construct(peer.getChild(i), names, inclusion, false);
            if (c != null) {
                children[numberOfChildrenFound++] = c;
            }
            ++i;
        }
        if (numberOfChildrenFound == 0) {
            return null;
        }
        if (numberOfChildrenFound == 1) {
            children[0].increaseBranchLength(branchLength);
            return children[0];
        }
        RNode[] realChildren = new RNode[numberOfChildrenFound];
        System.arraycopy(children, 0, realChildren, 0, numberOfChildrenFound);
        return new InternalNode(realChildren, branchLength);
    }

    private static final class InternalNode
    implements RNode {
        private final RNode[] children_;
        private double branchLength_;

        public InternalNode(RNode left, RNode right, double branchLength) {
            this(new RNode[]{left, right}, branchLength);
        }

        public InternalNode(RNode[] children, double branchLength) {
            this.children_ = children;
            this.branchLength_ = branchLength;
        }

        public void zeroBranchLength() {
            this.branchLength_ = 0.0;
        }

        public void increaseBranchLength(double amount) {
            this.branchLength_ += amount;
        }

        public Node constructPAL() {
            Node[] palChildren = new Node[this.children_.length];
            int i = 0;
            while (i < palChildren.length) {
                palChildren[i] = this.children_[i].constructPAL();
                ++i;
            }
            return NodeFactory.createNodeBranchLength(this.branchLength_, palChildren);
        }
    }

    private static final class LeafNode
    implements RNode {
        private final String leafID_;
        private double branchLength_;

        public LeafNode(String leafID, double branchLength) {
            this.leafID_ = leafID;
            this.branchLength_ = branchLength;
        }

        public void increaseBranchLength(double amount) {
            this.branchLength_ += amount;
        }

        public void zeroBranchLength() {
            this.branchLength_ = 0.0;
        }

        public Node constructPAL() {
            return NodeFactory.createNodeBranchLength(this.branchLength_, new Identifier(this.leafID_));
        }
    }

    private static interface RNode {
        public Node constructPAL();

        public void increaseBranchLength(double var1);

        public void zeroBranchLength();
    }
}

