/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.PrintWriter;
import java.util.Hashtable;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.alignment.SimpleAlignment;
import pal.io.FormattedOutput;
import pal.math.MersenneTwisterFast;
import pal.mep.MutationRateModel;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.LabelMapping;
import pal.misc.SimpleIdGroup;
import pal.misc.TimeOrderCharacterData;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;
import pal.tree.SplitSystem;
import pal.tree.SplitUtils;
import pal.tree.Tree;
import pal.tree.TreeGenerator;
import pal.util.AlgorithmCallback;

public class TreeUtils {
    private static MersenneTwisterFast random = new MersenneTwisterFast();
    private static Node[] path;
    private static FormattedOutput format;
    private static double proportion;
    private static int minLength;
    private static boolean[] umbrella;
    private static int[] position;
    private static int numExternalNodes;
    private static int numInternalNodes;
    private static int numBranches;

    public static double getRobinsonFouldsDistance(Tree t1, Tree t2) {
        SplitSystem s1 = SplitUtils.getSplits(t1);
        return TreeUtils.getRobinsonFouldsDistance(s1, t2);
    }

    public static double getRobinsonFouldsDistance(SplitSystem s1, Tree t2) {
        IdGroup idGroup = s1.getIdGroup();
        SplitSystem s2 = SplitUtils.getSplits(idGroup, t2);
        if (s1.getLabelCount() != s2.getLabelCount()) {
            throw new IllegalArgumentException("Number of labels must be the same!");
        }
        int ns1 = s1.getSplitCount();
        int ns2 = s2.getSplitCount();
        int fn = 0;
        int i = 0;
        while (i < ns1) {
            if (!s2.hasSplit(s1.getSplit(i))) {
                ++fn;
            }
            ++i;
        }
        int fp = 0;
        int i2 = 0;
        while (i2 < ns2) {
            if (!s1.hasSplit(s2.getSplit(i2))) {
                ++fp;
            }
            ++i2;
        }
        return 0.5 * ((double)fp + (double)fn);
    }

    public static double getRobinsonFouldsRescaledDistance(Tree t1, Tree t2) {
        SplitSystem s1 = SplitUtils.getSplits(t1);
        return TreeUtils.getRobinsonFouldsRescaledDistance(s1, t2);
    }

    public static double getRobinsonFouldsRescaledDistance(SplitSystem s1, Tree t2) {
        return TreeUtils.getRobinsonFouldsDistance(s1, t2) / (double)s1.getSplitCount();
    }

    public static Node getRandomNode(Tree tree) {
        int index = random.nextInt(tree.getExternalNodeCount() + tree.getInternalNodeCount());
        if (index >= tree.getExternalNodeCount()) {
            return tree.getInternalNode(index - tree.getExternalNodeCount());
        }
        return tree.getExternalNode(index);
    }

    public static final Node getNodeByName(Tree tree, String name) {
        return TreeUtils.getNodeByName(tree.getRoot(), name);
    }

    public static final Node getNodeByName(Node root, String name) {
        if (root.getIdentifier().getName().equals(name)) {
            return root;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            Node result = TreeUtils.getNodeByName(root.getChild(i), name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Tree mutationsToGenerations(Tree mutationTree, MutationRateModel muModel) {
        return TreeUtils.scale(mutationTree, muModel, 1);
    }

    public static Tree generationsToMutations(Tree generationTree, MutationRateModel muModel) {
        if (muModel.getUnits() != 1) {
            throw new IllegalArgumentException("Mutation rate must be per generation!");
        }
        return TreeUtils.generationsToMutations(generationTree, muModel, 1.0);
    }

    public static Tree generationsToMutations(Tree generationTree, MutationRateModel muModel, double generationTime) {
        if (generationTree.getUnits() != 1) {
            throw new IllegalArgumentException("Tree must be in units of generations!");
        }
        if (muModel.getMutationRate(0.0) <= 0.0) {
            throw new IllegalArgumentException("Non-positive mutation rate is not permitted!");
        }
        SimpleTree tree = new SimpleTree(generationTree);
        int i = 0;
        while (i < tree.getExternalNodeCount()) {
            double oldHeight = tree.getExternalNode(i).getNodeHeight();
            tree.getExternalNode(i).setNodeHeight(muModel.getExpectedSubstitutions(oldHeight) * generationTime);
            ++i;
        }
        int i2 = 0;
        while (i2 < tree.getInternalNodeCount()) {
            double oldHeight = tree.getInternalNode(i2).getNodeHeight();
            tree.getInternalNode(i2).setNodeHeight(muModel.getExpectedSubstitutions(oldHeight) * generationTime);
            ++i2;
        }
        NodeUtils.heights2Lengths(tree.getRoot(), false);
        tree.setUnits(0);
        return tree;
    }

    public static Tree scale(Tree oldTree, double rate, int newUnits) {
        return TreeUtils.getScaled(oldTree, rate, newUnits);
    }

    public static final Tree getScaled(Tree oldTree, double rate) {
        return TreeUtils.getScaled(oldTree, rate, oldTree.getUnits());
    }

    public static final Tree getScaled(Tree oldTree, double rate, int newUnits) {
        SimpleTree tree = new SimpleTree(oldTree);
        int i = 0;
        while (i < tree.getExternalNodeCount()) {
            Node n = tree.getExternalNode(i);
            n.setNodeHeight(rate * n.getNodeHeight());
            ++i;
        }
        int i2 = 0;
        while (i2 < tree.getInternalNodeCount()) {
            Node n = tree.getInternalNode(i2);
            n.setNodeHeight(rate * n.getNodeHeight());
            ++i2;
        }
        NodeUtils.heights2Lengths(tree.getRoot());
        tree.setUnits(newUnits);
        return tree;
    }

    public static Tree scale(Tree mutationRateTree, MutationRateModel muModel) {
        return TreeUtils.getScaled(mutationRateTree, muModel);
    }

    public static Tree getScaled(Tree mutationRateTree, MutationRateModel muModel) {
        return TreeUtils.getScaled(mutationRateTree, muModel, muModel.getUnits());
    }

    public static Tree scale(Tree mutationRateTree, MutationRateModel muModel, int newUnits) {
        return TreeUtils.getScaled(mutationRateTree, muModel, newUnits);
    }

    public static Tree getScaled(Tree mutationRateTree, MutationRateModel muModel, int newUnits) {
        if (muModel.getMutationRate(0.0) <= 0.0) {
            throw new IllegalArgumentException("Non-positive mutation rate is not permitted!");
        }
        SimpleTree tree = new SimpleTree(mutationRateTree);
        if (newUnits == 0) {
            int i = 0;
            while (i < tree.getExternalNodeCount()) {
                double oldHeight = tree.getExternalNode(i).getNodeHeight();
                tree.getExternalNode(i).setNodeHeight(muModel.getExpectedSubstitutions(oldHeight));
                ++i;
            }
            int i2 = 0;
            while (i2 < tree.getInternalNodeCount()) {
                double oldHeight = tree.getInternalNode(i2).getNodeHeight();
                tree.getInternalNode(i2).setNodeHeight(muModel.getExpectedSubstitutions(oldHeight));
                ++i2;
            }
        } else {
            int i = 0;
            while (i < tree.getExternalNodeCount()) {
                double oldHeight = tree.getExternalNode(i).getNodeHeight();
                tree.getExternalNode(i).setNodeHeight(muModel.getTime(oldHeight));
                ++i;
            }
            int i3 = 0;
            while (i3 < tree.getInternalNodeCount()) {
                double oldHeight = tree.getInternalNode(i3).getNodeHeight();
                tree.getInternalNode(i3).setNodeHeight(muModel.getTime(oldHeight));
                ++i3;
            }
        }
        NodeUtils.heights2Lengths(tree.getRoot());
        tree.setUnits(newUnits);
        return tree;
    }

    public static void renameNodes(Tree tree, Hashtable table) {
        tree.createNodeList();
        int i = 0;
        while (i < tree.getExternalNodeCount()) {
            String newName = (String)table.get(tree.getExternalNode(i).getIdentifier().getName());
            if (newName != null) {
                tree.getExternalNode(i).setIdentifier(new Identifier(newName));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < tree.getInternalNodeCount()) {
            String newName = (String)table.get(tree.getInternalNode(i2).getIdentifier().getName());
            if (newName != null) {
                tree.getInternalNode(i2).setIdentifier(new Identifier(newName));
            }
            ++i2;
        }
    }

    public static void rotateByLeafCount(Tree tree) {
        TreeUtils.rotateByLeafCount(tree.getRoot());
    }

    public static final IdGroup getLeafIdGroup(Tree tree) {
        tree.createNodeList();
        SimpleIdGroup labelList = new SimpleIdGroup(tree.getExternalNodeCount());
        int i = 0;
        while (i < tree.getExternalNodeCount()) {
            labelList.setIdentifier(i, tree.getExternalNode(i).getIdentifier());
            ++i;
        }
        return labelList;
    }

    public static final int[] mapExternalIdentifiers(IdGroup idGroup, Tree tree) throws IllegalArgumentException {
        int[] alias = new int[tree.getExternalNodeCount()];
        int i = 0;
        while (i < tree.getExternalNodeCount()) {
            alias[i] = idGroup.whichIdNumber(tree.getExternalNode(i).getIdentifier().getName());
            if (alias[i] == -1) {
                throw new IllegalArgumentException("Tree label " + tree.getExternalNode(i).getIdentifier() + " not present in given set of labels");
            }
            ++i;
        }
        return alias;
    }

    /*
     * Unable to fully structure code
     */
    public static final void labelInternalNodes(Tree tree) {
        counter = 0;
        pos = "0";
        ids = TreeUtils.getLeafIdGroup(tree);
        i = 0;
        ** GOTO lbl12
        {
            pos = "" + ++counter;
            do {
                if (ids.whichIdNumber(pos) >= 0) continue block0;
                tree.getInternalNode(i).setIdentifier(new Identifier(pos));
                pos = "" + ++counter;
                ++i;
lbl12:
                // 2 sources

            } while (i < tree.getInternalNodeCount());
        }
    }

    public static TimeOrderCharacterData extractTimeOrderCharacterData(Tree tree, int units) {
        tree.createNodeList();
        IdGroup identifiers = TreeUtils.getLeafIdGroup(tree);
        TimeOrderCharacterData tocd = new TimeOrderCharacterData(identifiers, units);
        double[] times = new double[tree.getExternalNodeCount()];
        int i = 0;
        while (i < times.length) {
            times[i] = tree.getExternalNode(i).getNodeHeight();
            ++i;
        }
        tocd.setTimes(times, units);
        return tocd;
    }

    public static Alignment extractAlignment(Tree tree, boolean leaveSeqsInTree) {
        tree.createNodeList();
        String[] sequences = new String[tree.getExternalNodeCount()];
        Identifier[] ids = new Identifier[sequences.length];
        int i = 0;
        while (i < sequences.length) {
            sequences[i] = new String(tree.getExternalNode(i).getSequence());
            ids[i] = tree.getExternalNode(i).getIdentifier();
            if (!leaveSeqsInTree) {
                tree.getExternalNode(i).setSequence(null);
            }
            ++i;
        }
        return new SimpleAlignment(ids, sequences, "-", AlignmentUtils.getSuitableInstance(sequences));
    }

    public static Alignment extractAlignment(Tree tree) {
        return TreeUtils.extractAlignment(tree, true);
    }

    public static void printNH(Tree tree, PrintWriter out) {
        TreeUtils.printNH(tree, out, true, true);
    }

    public static void printNH(Tree tree, PrintWriter out, boolean printLengths, boolean printInternalLabels) {
        NodeUtils.printNH(out, tree.getRoot(), printLengths, printInternalLabels);
        out.println(";");
    }

    public static void reroot(Tree tree, Node node) {
        TreeUtils.reroot(node);
        tree.setRoot(node);
    }

    public static void computeAllDistances(Tree tree, int a, double[] dist, double[] idist, boolean countEdges, double epsilon) {
        tree.createNodeList();
        dist[a] = 0.0;
        Node node = tree.getExternalNode(a);
        TreeUtils.computeNodeDist(node, node.getParent(), dist, idist, countEdges, epsilon);
    }

    private static void computeNodeDist(Node origin, Node center, double[] dist, double[] idist, boolean countEdges, double epsilon) {
        int indexCenter = center.getNumber();
        int indexOrigin = origin.getNumber();
        double[] distCenter = center.isLeaf() ? dist : idist;
        double[] distOrigin = origin.isLeaf() ? dist : idist;
        double tmp = origin.getParent() == center ? origin.getBranchLength() : center.getBranchLength();
        double len = countEdges ? (tmp < epsilon ? 0.0 : 1.0) : tmp;
        distCenter[indexCenter] = distOrigin[indexOrigin] + len;
        if (!center.isLeaf()) {
            Node p;
            int i = 0;
            while (i < center.getChildCount()) {
                Node c = center.getChild(i);
                if (c != origin) {
                    TreeUtils.computeNodeDist(center, c, dist, idist, countEdges, epsilon);
                }
                ++i;
            }
            if (!center.isRoot() && (p = center.getParent()) != origin) {
                TreeUtils.computeNodeDist(center, p, dist, idist, countEdges, epsilon);
            }
        }
    }

    public static final double computeDistance(Tree tree, int a, int b) {
        tree.createNodeList();
        int maxLen = tree.getInternalNodeCount() + 1;
        if (path == null || path.length < maxLen) {
            path = new Node[maxLen];
        }
        int len = TreeUtils.findPath(tree, a, b);
        double dist = 0.0;
        int i = 0;
        while (i < len) {
            dist += path[i].getBranchLength();
            ++i;
        }
        return dist;
    }

    private static final int findPath(Tree tree, int a, int b) {
        int i = 0;
        while (i < path.length) {
            TreeUtils.path[i] = null;
            ++i;
        }
        Node node = tree.getExternalNode(a);
        int len = 0;
        TreeUtils.path[len] = node;
        ++len;
        while (!node.isRoot()) {
            TreeUtils.path[len] = node = node.getParent();
            ++len;
        }
        Node stopNode = null;
        node = tree.getExternalNode(b);
        while (!node.isRoot()) {
            int pos = TreeUtils.findInPath(node = node.getParent());
            if (pos == -1) continue;
            len = pos;
            stopNode = node;
            break;
        }
        TreeUtils.path[len] = node = tree.getExternalNode(b);
        ++len;
        node = node.getParent();
        while (node != stopNode) {
            TreeUtils.path[len] = node;
            ++len;
            node = node.getParent();
        }
        int i2 = len;
        while (i2 < path.length) {
            TreeUtils.path[i2] = null;
            ++i2;
        }
        return len;
    }

    private static final int findInPath(Node node) {
        int i = 0;
        while (i < path.length) {
            if (path[i] == node) {
                return i;
            }
            if (path[i] == null) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    private static void rotateByLeafCount(Node node) {
        if (!node.isLeaf()) {
            if (NodeUtils.getLeafCount(node.getChild(0)) > NodeUtils.getLeafCount(node.getChild(1))) {
                Node temp = node.getChild(0);
                node.removeChild(0);
                node.addChild(temp);
            }
            int i = 0;
            while (i < node.getChildCount()) {
                TreeUtils.rotateByLeafCount(node.getChild(i));
                ++i;
            }
        }
    }

    public static void report(Tree tree, PrintWriter out) {
        TreeUtils.printASCII(tree, out);
        out.println();
        TreeUtils.branchInfo(tree, out);
        out.println();
        TreeUtils.heightInfo(tree, out);
    }

    private static void printASCII(Tree tree, PrintWriter out) {
        format = FormattedOutput.getInstance();
        tree.createNodeList();
        numExternalNodes = tree.getExternalNodeCount();
        numInternalNodes = tree.getInternalNodeCount();
        numBranches = numInternalNodes + numExternalNodes - 1;
        umbrella = new boolean[numExternalNodes];
        position = new int[numExternalNodes];
        minLength = Integer.toString(numBranches).length() + 1;
        int MAXCOLUMN = 40;
        Node root = tree.getRoot();
        if (root.getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(root);
        }
        proportion = (double)MAXCOLUMN / root.getNodeHeight();
        int n = 0;
        while (n < numExternalNodes) {
            TreeUtils.umbrella[n] = false;
            ++n;
        }
        TreeUtils.position[0] = 1;
        int i = root.getChildCount() - 1;
        while (i > -1) {
            TreeUtils.printNodeInASCII(out, root.getChild(i), 1, i, root.getChildCount());
            if (i != 0) {
                TreeUtils.putCharAtLevel(out, 0, '|');
                out.println();
            }
            --i;
        }
    }

    private static void branchInfo(Tree tree, PrintWriter out) {
        boolean showSE = false;
        int i = 0;
        while (i < numExternalNodes && !showSE) {
            if (tree.getExternalNode(i).getBranchLengthSE() != 0.0) {
                showSE = true;
            }
            if (i < numInternalNodes - 1 && tree.getInternalNode(i).getBranchLengthSE() != 0.0) {
                showSE = true;
            }
            ++i;
        }
        format.displayIntegerWhite(out, numExternalNodes);
        out.print("   Length    ");
        if (showSE) {
            out.print("S.E.      ");
        }
        out.print("Label     ");
        if (numInternalNodes > 1) {
            format.displayIntegerWhite(out, numBranches);
            out.print("        Length    ");
            if (showSE) {
                out.print("S.E.      ");
            }
            out.print("Label");
        }
        out.println();
        int i2 = 0;
        while (i2 < numExternalNodes) {
            format.displayInteger(out, i2 + 1, numExternalNodes);
            out.print("   ");
            format.displayDecimal(out, tree.getExternalNode(i2).getBranchLength(), 5);
            out.print("   ");
            if (showSE) {
                format.displayDecimal(out, tree.getExternalNode(i2).getBranchLengthSE(), 5);
                out.print("   ");
            }
            format.displayLabel(out, tree.getExternalNode(i2).getIdentifier().getName(), 10);
            if (i2 < numInternalNodes - 1) {
                format.multiplePrint(out, ' ', 5);
                format.displayInteger(out, i2 + 1 + numExternalNodes, numBranches);
                out.print("   ");
                format.displayDecimal(out, tree.getInternalNode(i2).getBranchLength(), 5);
                out.print("   ");
                if (showSE) {
                    format.displayDecimal(out, tree.getInternalNode(i2).getBranchLengthSE(), 5);
                    out.print("   ");
                }
                format.displayLabel(out, tree.getInternalNode(i2).getIdentifier().getName(), 10);
            }
            out.println();
            ++i2;
        }
    }

    private static void heightInfo(Tree tree, PrintWriter out) {
        if (tree.getRoot().getNodeHeight() == 0.0) {
            NodeUtils.lengths2Heights(tree.getRoot());
        }
        format.displayIntegerWhite(out, numExternalNodes);
        out.print("   Height    ");
        format.displayIntegerWhite(out, numBranches);
        out.print("        Height    ");
        out.println();
        int i = 0;
        while (i < numExternalNodes) {
            format.displayInteger(out, i + 1, numExternalNodes);
            out.print("   ");
            format.displayDecimal(out, tree.getExternalNode(i).getNodeHeight(), 7);
            out.print("   ");
            if (i < numInternalNodes) {
                format.multiplePrint(out, ' ', 5);
                if (i == numInternalNodes - 1) {
                    out.print("R");
                    format.multiplePrint(out, ' ', Integer.toString(numBranches).length() - 1);
                } else {
                    format.displayInteger(out, i + 1 + numExternalNodes, numBranches);
                }
                out.print("   ");
                format.displayDecimal(out, tree.getInternalNode(i).getNodeHeight(), 7);
                out.print("   ");
            }
            out.println();
            ++i;
        }
    }

    private static void printNodeInASCII(PrintWriter out, Node node, int level, int m, int maxm) {
        TreeUtils.position[level] = (int)(node.getBranchLength() * proportion);
        if (position[level] < minLength) {
            TreeUtils.position[level] = minLength;
        }
        if (node.isLeaf()) {
            if (m == maxm - 1) {
                TreeUtils.umbrella[level - 1] = true;
            }
            TreeUtils.printlnNodeWithNumberAndLabel(out, node, level);
            if (m == 0) {
                TreeUtils.umbrella[level - 1] = false;
            }
        } else {
            int n = node.getChildCount() - 1;
            while (n > -1) {
                TreeUtils.printNodeInASCII(out, node.getChild(n), level + 1, n, node.getChildCount());
                if (m == maxm - 1 && n == node.getChildCount() / 2) {
                    TreeUtils.umbrella[level - 1] = true;
                }
                if (n != 0) {
                    if (n == node.getChildCount() / 2) {
                        TreeUtils.printlnNodeWithNumberAndLabel(out, node, level);
                    } else {
                        int i = 0;
                        while (i < level + 1) {
                            if (umbrella[i]) {
                                TreeUtils.putCharAtLevel(out, i, '|');
                            } else {
                                TreeUtils.putCharAtLevel(out, i, ' ');
                            }
                            ++i;
                        }
                        out.println();
                    }
                }
                if (m == 0 && n == node.getChildCount() / 2) {
                    TreeUtils.umbrella[level - 1] = false;
                }
                --n;
            }
        }
    }

    private static void printlnNodeWithNumberAndLabel(PrintWriter out, Node node, int level) {
        int i = 0;
        while (i < level - 1) {
            if (umbrella[i]) {
                TreeUtils.putCharAtLevel(out, i, '|');
            } else {
                TreeUtils.putCharAtLevel(out, i, ' ');
            }
            ++i;
        }
        TreeUtils.putCharAtLevel(out, level - 1, '+');
        int branchNumber = node.isLeaf() ? node.getNumber() + 1 : node.getNumber() + 1 + numExternalNodes;
        String numberAsString = Integer.toString(branchNumber);
        int numDashs = position[level] - numberAsString.length();
        int i2 = 0;
        while (i2 < numDashs) {
            out.print('-');
            ++i2;
        }
        out.print(numberAsString);
        if (node.isLeaf()) {
            out.println(" " + node.getIdentifier());
        } else {
            if (!node.getIdentifier().equals(Identifier.ANONYMOUS)) {
                out.print("(" + node.getIdentifier() + ")");
            }
            out.println();
        }
    }

    private static void putCharAtLevel(PrintWriter out, int level, char c) {
        int n = position[level] - 1;
        int i = 0;
        while (i < n) {
            out.print(' ');
            ++i;
        }
        out.print(c);
    }

    private static void reroot(Node node) {
        if (node.isRoot() || node.isLeaf()) {
            return;
        }
        if (!node.getParent().isRoot()) {
            TreeUtils.reroot(node.getParent());
        }
        if (node.getParent().getChildCount() < 3) {
            return;
        }
        NodeUtils.exchangeInfo(node.getParent(), node);
        Node parent = node.getParent();
        NodeUtils.removeChild(parent, node);
        node.addChild(parent);
    }

    public static final Tree getBootstrapSupportByCladeTree(String attributeName, Tree baseTree, Tree[] alternativeTrees) {
        SimpleTree result = new SimpleTree(baseTree);
        IdGroup ids = TreeUtils.getLeafIdGroup(baseTree);
        SplitSystem baseSystem = SplitUtils.getSplits(ids, baseTree);
        boolean[][] baseVector = baseSystem.getSplitVector();
        int[] supportCount = new int[baseVector.length];
        int i = 0;
        while (i < alternativeTrees.length) {
            SplitSystem alternativeSystem = SplitUtils.getSplits(ids, alternativeTrees[i]);
            int j = 0;
            while (j < baseVector.length) {
                if (alternativeSystem.hasSplit(baseVector[j])) {
                    int n = j;
                    supportCount[n] = supportCount[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < supportCount.length) {
            int support = (int)((double)(supportCount[i2] * 100) / (double)alternativeTrees.length);
            result.setAttribute(result.getInternalNode(i2), attributeName, new Integer(support));
            ++i2;
        }
        return result;
    }

    public static final Tree getReplicateCladeSupport(String attributeName, Tree baseTree, TreeGenerator treeGenerator, int numberOfReplicates, AlgorithmCallback callback) {
        SimpleTree result = new SimpleTree(baseTree);
        IdGroup ids = TreeUtils.getLeafIdGroup(baseTree);
        SplitSystem baseSystem = SplitUtils.getSplits(ids, baseTree);
        boolean[][] baseVector = baseSystem.getSplitVector();
        int[] supportCount = new int[baseVector.length];
        int i = 0;
        while (i < numberOfReplicates) {
            Tree replicateTree = treeGenerator.getNextTree(AlgorithmCallback.Utils.getSubCallback(callback, "Replicate:" + i, (double)i / (double)(numberOfReplicates + 1), (double)(i + 1) / (double)(numberOfReplicates + 1)));
            if (callback.isPleaseStop()) {
                return baseTree;
            }
            SplitSystem alternativeSystem = SplitUtils.getSplits(ids, replicateTree);
            int j = 0;
            while (j < baseVector.length) {
                if (alternativeSystem.hasSplit(baseVector[j])) {
                    int n = j;
                    supportCount[n] = supportCount[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < supportCount.length) {
            int support = (int)((double)(supportCount[i2] * 100) / (double)numberOfReplicates);
            result.setAttribute(result.getInternalNode(i2), attributeName, new Integer(support));
            ++i2;
        }
        return result;
    }

    public static final Tree getNumberRelabelledTree(Tree baseTree, IdGroup ids) {
        LabelMapping lm = new LabelMapping();
        int minIndex = Integer.MAX_VALUE;
        int i = 0;
        while (i < baseTree.getIdCount()) {
            String treeLabel = baseTree.getIdentifier(i).getName();
            try {
                int number = Integer.parseInt(treeLabel);
                if (number < minIndex) {
                    minIndex = number;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++i;
        }
        int changes = 0;
        int i2 = 0;
        while (i2 < baseTree.getIdCount()) {
            String treeLabel = baseTree.getIdentifier(i2).getName();
            try {
                int number = Integer.parseInt(treeLabel) - minIndex;
                if (number < ids.getIdCount()) {
                    lm.addMapping(treeLabel, ids.getIdentifier(number).getName());
                    ++changes;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++i2;
        }
        if (changes == 0) {
            return baseTree;
        }
        return new SimpleTree(baseTree, lm);
    }
}

