/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.tree.Node;
import pal.tree.TreeManipulator;

public interface UnrootedTreeInterface {
    public BaseBranch createBase();

    public static final class Utils {
        private static final void create(Node palNode, UNode uNode) {
            int numberOfChildren = palNode.getChildCount();
            uNode.resetChildren();
            if (numberOfChildren == 0) {
                uNode.setLabel(palNode.getIdentifier().getName());
            } else {
                int i = 0;
                while (i < numberOfChildren) {
                    Node palChild = palNode.getChild(i);
                    UNode displayChild = uNode.createUChild();
                    UBranch b = displayChild.getParentUBranch();
                    b.setLength(palChild.getBranchLength());
                    Utils.create(palChild, displayChild);
                    ++i;
                }
            }
        }

        public static final void instruct(Node root, UnrootedTreeInterface treeInterface) {
            if (root.getChildCount() != 2) {
                root = new TreeManipulator(root).getMidPointRooted();
            }
            BaseBranch b = treeInterface.createBase();
            Node palLeft = root.getChild(0);
            Node palRight = root.getChild(1);
            b.setLength(palLeft.getBranchLength() + palRight.getBranchLength());
            Utils.create(palLeft, b.getLeftNode());
            Utils.create(palRight, b.getRightNode());
        }
    }

    public static interface BaseBranch
    extends GeneralBranch {
        public UNode getLeftNode();

        public UNode getRightNode();
    }

    public static interface UBranch
    extends GeneralBranch {
        public UNode getCloserNode();

        public UNode getFartherNode();
    }

    public static interface GeneralBranch {
        public void setLength(double var1);

        public void setAnnotation(Object var1);
    }

    public static interface UNode {
        public UBranch getParentUBranch();

        public void setLabel(String var1);

        public void setAnnotation(Object var1);

        public void resetChildren();

        public UNode createUChild();
    }

    public static interface Instructee {
        public void instruct(UnrootedTreeInterface var1);
    }
}

