/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.math.MathUtils;
import pal.math.UnivariateFunction;
import pal.math.UnivariateMinimum;
import pal.tree.Node;
import pal.treesearch.AbstractParentableConstrainedNode;
import pal.treesearch.ConstrainedNode;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.GeneralOptimisable;
import pal.treesearch.ParentableConstrainedNode;
import pal.treesearch.PivotNode;

public class ConstrainedInternalNode
extends AbstractParentableConstrainedNode
implements ConstrainedNode,
GeneralOptimisable {
    private ParentableConstrainedNode parentNode_;
    private final PatternInfo centerPattern_;
    private boolean centerPatternValid_;
    private final PatternInfo leftAscendedentPattern_;
    private boolean leftAscendentPatternValid_;
    private final PatternInfo rightAscendedentPattern_;
    private boolean rightAscendentPatternValid_;
    private final LocalShiftOptimisationHandler localShiftOptimisationHandler_;
    private final SubTreeShiftOptimisationHandler subTreeShiftOptimisationHandler_;
    private final PartialSubTreeShiftOptimisationHandler partialSubTreeShiftOptimisationHandler_;
    private PivotNode parentPivot_;

    public ConstrainedInternalNode(Node peer, ParentableConstrainedNode parentNode, GeneralConstructionTool tool, GeneralConstraintGroupManager.Store store, GeneralConstraintGroupManager groupManager) {
        super(peer, tool, store, groupManager);
        this.parentNode_ = parentNode;
        this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.centerPatternValid_ = false;
        this.leftAscendedentPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.leftAscendentPatternValid_ = false;
        this.rightAscendedentPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.rightAscendentPatternValid_ = false;
        this.localShiftOptimisationHandler_ = new LocalShiftOptimisationHandler(tool, this.getConstrainedInternal());
        this.subTreeShiftOptimisationHandler_ = new SubTreeShiftOptimisationHandler(tool, this.getConstrainedInternal());
        this.partialSubTreeShiftOptimisationHandler_ = new PartialSubTreeShiftOptimisationHandler(tool, this.getConstrainedInternal());
    }

    public void recursivelySetParentPivot(PivotNode parentPivot) {
        this.parentPivot_ = parentPivot;
        this.recursivelySetChildrenParentPivot(parentPivot);
    }

    public void getNonSubTreeComponents(ArrayList store, Class componentType) {
        if (this.parentNode_ != null) {
            this.parentNode_.getNonSubTreeOfChildComponents(store, componentType, this);
        }
    }

    public double calculateLogLikelihood(GeneralConstructionTool tool) {
        double height = this.getNodeHeight();
        ConditionalProbabilityStore descendentExtended = this.getDescendentExtendedConditionals(this.parentNode_.getNodeHeight(), tool, false);
        ConditionalProbabilityStore parentFlat = this.parentNode_.getAscendentFlat(this, tool, false);
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        return external.calculateLogLikelihoodNonRoot(this.parentNode_.getNodeHeight(), this.getCenterPattern(tool), parentFlat, descendentExtended);
    }

    public PatternInfo getCenterPattern(GeneralConstructionTool tool) {
        if (!this.centerPatternValid_) {
            tool.build(this.centerPattern_, this.parentNode_.getAscendentPatternInfo(this, tool), this.getDescendentPatternInfo(tool));
            this.centerPatternValid_ = true;
        }
        return this.centerPattern_;
    }

    public ConditionalProbabilityStore getAscendentExtended(double baseHeight, ConstrainedNode childCaller, GeneralConstructionTool tool, boolean allowCaching) {
        double height = this.getNodeHeight();
        if (this.isLeftChild(childCaller)) {
            ConditionalProbabilityStore right = this.getRightDescendentExtendedConditionals(tool, allowCaching);
            ConditionalProbabilityStore top = this.parentNode_.getAscendentExtended(height, this, tool, allowCaching);
            return this.getConstrainedInternal().calculateAscendentExtendedConditionals(height, baseHeight, this.getAscendentPatternInfo(childCaller, tool), top, right);
        }
        ConditionalProbabilityStore left = this.getLeftDescendentExtendedConditionals(tool, allowCaching);
        ConditionalProbabilityStore top = this.parentNode_.getAscendentExtended(height, this, tool, allowCaching);
        return this.getConstrainedInternal().calculateAscendentExtendedConditionals(height, baseHeight, this.getAscendentPatternInfo(childCaller, tool), top, left);
    }

    public ConditionalProbabilityStore getAscendentFlat(ConstrainedNode childCaller, GeneralConstructionTool tool, boolean allowCaching) {
        double height = this.getNodeHeight();
        if (this.isLeftChild(childCaller)) {
            ConditionalProbabilityStore right = this.getRightDescendentExtendedConditionals(tool, allowCaching);
            ConditionalProbabilityStore top = this.parentNode_.getAscendentExtended(height, this, tool, allowCaching);
            return this.getConstrainedInternal().calculateAscendentFlatConditionals(this.getAscendentPatternInfo(childCaller, tool), top, right);
        }
        ConditionalProbabilityStore left = this.getLeftDescendentExtendedConditionals(tool, allowCaching);
        ConditionalProbabilityStore top = this.parentNode_.getAscendentExtended(height, this, tool, allowCaching);
        return this.getConstrainedInternal().calculateAscendentFlatConditionals(this.getAscendentPatternInfo(childCaller, tool), top, left);
    }

    public void testLikelihood(GeneralConstructionTool tool) {
        System.out.println("Test (CIN):" + this.calculateLogLikelihood(tool));
        this.getLeftChild().testLikelihood(tool);
        this.getRightChild().testLikelihood(tool);
    }

    public PatternInfo getAscendentPatternInfo(ConstrainedNode childCaller, GeneralConstructionTool tool) {
        if (this.isLeftChild(childCaller)) {
            if (!this.leftAscendentPatternValid_) {
                tool.build(this.leftAscendedentPattern_, this.parentNode_.getAscendentPatternInfo(this, tool), this.getRightChildPatternInfo(tool));
                this.leftAscendentPatternValid_ = true;
            }
            return this.leftAscendedentPattern_;
        }
        if (!this.rightAscendentPatternValid_) {
            tool.build(this.rightAscendedentPattern_, this.parentNode_.getAscendentPatternInfo(this, tool), this.getLeftChildPatternInfo(tool));
            this.rightAscendentPatternValid_ = true;
        }
        return this.rightAscendedentPattern_;
    }

    public int getNumberOfOptimisationTypes() {
        return 3;
    }

    public double optimise(int optimisationType, UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        switch (optimisationType) {
            case 0: {
                return this.optimiseLocalShift(minimiser, tool, fracDigits);
            }
            case 1: {
                return this.optimisePartialSubTreeShift(minimiser, tool, fracDigits);
            }
        }
        return this.optimiseSubTreeShift(minimiser, tool, fracDigits);
    }

    private final double optimiseLocalShift(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        double parentHeight;
        double maxChildHeight = this.getMaxChildHeight();
        if (maxChildHeight >= (parentHeight = this.parentNode_.getNodeHeight())) {
            return 1.0;
        }
        double myHeight = this.getNodeHeight();
        ConditionalProbabilityStore temp = tool.obtainTempConditionalProbabilityStore();
        ConditionalProbabilityStore leftDescendentBaseExtended = this.getLeftDescendentExtendedConditionals(maxChildHeight, tool, false);
        ConditionalProbabilityStore rightDescendentBaseExtended = this.getRightDescendentExtendedConditionals(maxChildHeight, tool, false);
        ConditionalProbabilityStore parentFlat = this.parentNode_.getAscendentFlat(this, tool, false);
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        this.localShiftOptimisationHandler_.setup(parentFlat, this.parentNode_.getAscendentPatternInfo(this, tool), this.getCenterPattern(tool), leftDescendentBaseExtended, rightDescendentBaseExtended, this.getDescendentPatternInfo(tool), myHeight, maxChildHeight, parentHeight, this.obtainConstrainedExternalCalculator(), temp, fracDigits);
        this.localShiftOptimisationHandler_.optimise(minimiser);
        this.setNodeHeight(this.localShiftOptimisationHandler_.getHeight());
        return this.localShiftOptimisationHandler_.getLogLikelihood();
    }

    private final double optimiseSubTreeShift(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        double minOffset = this.getMinimumLeafChildSeperation();
        double parentHeight = this.parentNode_.getNodeHeight();
        double maxChildHeight = this.getMaxChildHeight();
        double baseHeight = this.getNodeHeight();
        ConditionalProbabilityStore temp = tool.obtainTempConditionalProbabilityStore();
        ConditionalProbabilityStore parentFlat = this.parentNode_.getAscendentFlat(this, tool, false);
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        this.subTreeShiftOptimisationHandler_.setup(parentFlat, this.parentNode_.getAscendentPatternInfo(this, tool), this.getCenterPattern(tool), this.getLeftChild(), this.getRightChild(), this.getDescendentPatternInfo(tool), baseHeight, -minOffset, parentHeight - baseHeight, parentHeight, this.obtainConstrainedExternalCalculator(), temp, fracDigits);
        this.subTreeShiftOptimisationHandler_.optimise(minimiser);
        this.recursivelyAdjustNodeHeight(this.subTreeShiftOptimisationHandler_);
        return this.subTreeShiftOptimisationHandler_.getLogLikelihood();
    }

    private final double optimisePartialSubTreeShift(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        double parentHeight = this.parentNode_.getNodeHeight();
        double maxChildHeight = this.getMaxChildHeight();
        double baseHeight = this.getNodeHeight();
        ConditionalProbabilityStore temp = tool.obtainTempConditionalProbabilityStore();
        ConditionalProbabilityStore parentFlat = this.parentNode_.getAscendentFlat(this, tool, false);
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        this.partialSubTreeShiftOptimisationHandler_.resetAffectedNodes();
        this.partialSubTreeShiftOptimisationHandler_.addMultification(this);
        if (this.partialSubTreeShiftOptimisationHandler_.getNumberOfAffected() == 1) {
            return 1.0;
        }
        this.partialSubTreeShiftOptimisationHandler_.setup(parentFlat, this.parentNode_.getAscendentPatternInfo(this, tool), this.getCenterPattern(tool), this.getLeftChild(), this.getRightChild(), this.getDescendentPatternInfo(tool), baseHeight, -this.partialSubTreeShiftOptimisationHandler_.getMinimumAffectedChildDistance(), parentHeight - baseHeight, parentHeight, this.obtainConstrainedExternalCalculator(), temp, fracDigits);
        this.partialSubTreeShiftOptimisationHandler_.optimise(minimiser);
        this.recursivelyAdjustNodeHeight(this.partialSubTreeShiftOptimisationHandler_);
        double l = this.partialSubTreeShiftOptimisationHandler_.getLogLikelihood();
        return l;
    }

    private final class PartialSubTreeShiftOptimisationHandler
    implements UnivariateFunction,
    ConstrainedNode.HeightAdjustment {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private ConditionalProbabilityStore ascendentFlat_;
        private ConditionalProbabilityStore tempConditionals_;
        private PatternInfo descendentPattern_;
        private PatternInfo ascendentPattern_;
        private PatternInfo centerPattern_;
        private ConstrainedNode leftChild_;
        private ConstrainedNode rightChild_;
        private double parentHeight_;
        private double baseHeight_;
        private double offset_;
        private double minimumOffset_;
        private double maximumOffset_;
        private int fracDigits_;
        private ConstrainedNode[] affectedNodes_;
        private int numberOfAffectedNodes_ = 0;

        public PartialSubTreeShiftOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public double getAdjustedHeight(Object relatedNode, double baseHeightToAdjust) {
            int i = 0;
            while (i < this.numberOfAffectedNodes_) {
                if (relatedNode == this.affectedNodes_[i]) {
                    return baseHeightToAdjust + this.offset_;
                }
                ++i;
            }
            return baseHeightToAdjust;
        }

        public int getNumberOfAffected() {
            return this.numberOfAffectedNodes_;
        }

        public void addMultification(ConstrainedNode base) {
            this.addAffectedNode(base);
            ConstrainedNode left = base.getLeftChild();
            ConstrainedNode right = base.getRightChild();
            double baseHeight = base.getNodeHeight();
            if (left != null) {
                if (baseHeight - left.getNodeHeight() < 1.0E-6) {
                    this.addMultification(left);
                }
                if (baseHeight - right.getNodeHeight() < 1.0E-6) {
                    this.addMultification(right);
                }
            }
        }

        public double getMinimumAffectedChildDistance() {
            double distance = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.numberOfAffectedNodes_) {
                distance = Math.min(distance, this.affectedNodes_[i].getMinimumDirectChildDistance());
                ++i;
            }
            return distance;
        }

        public void resetAffectedNodes() {
            this.numberOfAffectedNodes_ = 0;
        }

        public void addAffectedNode(ConstrainedNode node) {
            if (this.affectedNodes_ == null) {
                this.affectedNodes_ = new ConstrainedNode[10];
            } else if (this.numberOfAffectedNodes_ == this.affectedNodes_.length) {
                ConstrainedNode[] newAffected = new ConstrainedNode[this.numberOfAffectedNodes_ + 5];
                System.arraycopy(this.affectedNodes_, 0, newAffected, 0, this.numberOfAffectedNodes_);
                this.affectedNodes_ = newAffected;
            }
            this.affectedNodes_[this.numberOfAffectedNodes_++] = node;
        }

        public void setup(ConditionalProbabilityStore ascendentFlat, PatternInfo ascendentPattern, PatternInfo centerPattern, ConstrainedNode leftChild, ConstrainedNode rightChild, PatternInfo descendentPattern, double baseHeight, double minimumOffset, double maximumOffset, double parentHeight, MolecularClockLikelihoodModel.External external, ConditionalProbabilityStore tempConditionals, int fracDigits) {
            this.baseHeight_ = baseHeight;
            this.ascendentFlat_ = ascendentFlat;
            this.ascendentPattern_ = ascendentPattern;
            this.centerPattern_ = centerPattern;
            this.descendentPattern_ = descendentPattern;
            this.leftChild_ = leftChild;
            this.rightChild_ = rightChild;
            this.minimumOffset_ = minimumOffset;
            this.maximumOffset_ = maximumOffset;
            this.parentHeight_ = parentHeight;
            this.tempConditionals_ = tempConditionals;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.offset_ = 0.0;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(0.0, this, this.fracDigits_);
            this.offset_ = MathUtils.ensureBounded(minimiser.minx, this.minimumOffset_, this.maximumOffset_);
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.baseHeight_ + this.offset_;
        }

        public double getOffset() {
            return this.offset_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double offset) {
            this.offset_ = offset;
            double adjustedHeight = this.baseHeight_ + this.offset_;
            ConditionalProbabilityStore left = this.leftChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            ConditionalProbabilityStore right = this.rightChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            ConditionalProbabilityStore descendentExtended = this.internal_.calculateFlatConditionals(this.descendentPattern_, left, right);
            this.external_.calculateSingleAscendentExtendedConditionalsIndirect(this.parentHeight_, adjustedHeight, this.ascendentPattern_, this.ascendentFlat_, this.tempConditionals_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(adjustedHeight, this.centerPattern_, this.tempConditionals_, descendentExtended);
            return result;
        }

        private final void test() {
            ConditionalProbabilityStore left = this.leftChild_.getDescendentExtendedConditionals(this.baseHeight_, this.tool_, false);
            ConditionalProbabilityStore right = this.rightChild_.getDescendentExtendedConditionals(this.baseHeight_, this.tool_, false);
            ConditionalProbabilityStore descendentExtended = this.internal_.calculateFlatConditionals(this.descendentPattern_, left, right);
            this.external_.calculateSingleAscendentExtendedConditionalsIndirect(this.parentHeight_, this.baseHeight_, this.ascendentPattern_, this.ascendentFlat_, this.tempConditionals_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(this.baseHeight_, this.centerPattern_, this.tempConditionals_, descendentExtended);
            System.out.println("Test:" + result);
        }

        public double getLowerBound() {
            return this.minimumOffset_;
        }

        public double getUpperBound() {
            return this.maximumOffset_;
        }
    }

    private final class SubTreeShiftOptimisationHandler
    implements UnivariateFunction,
    ConstrainedNode.HeightAdjustment {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private ConditionalProbabilityStore ascendentFlat_;
        private ConditionalProbabilityStore tempConditionals_;
        private PatternInfo descendentPattern_;
        private PatternInfo ascendentPattern_;
        private PatternInfo centerPattern_;
        private ConstrainedNode leftChild_;
        private ConstrainedNode rightChild_;
        private double parentHeight_;
        private double baseHeight_;
        private double offset_;
        private double minimumOffset_;
        private double maximumOffset_;
        private int fracDigits_;

        public SubTreeShiftOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public double getAdjustedHeight(Object related, double baseHeightToAdjust) {
            return baseHeightToAdjust + this.offset_;
        }

        public void setup(ConditionalProbabilityStore ascendentFlat, PatternInfo ascendentPattern, PatternInfo centerPattern, ConstrainedNode leftChild, ConstrainedNode rightChild, PatternInfo descendentPattern, double baseHeight, double minimumOffset, double maximumOffset, double parentHeight, MolecularClockLikelihoodModel.External external, ConditionalProbabilityStore tempConditionals, int fracDigits) {
            this.baseHeight_ = baseHeight;
            this.ascendentFlat_ = ascendentFlat;
            this.ascendentPattern_ = ascendentPattern;
            this.centerPattern_ = centerPattern;
            this.descendentPattern_ = descendentPattern;
            this.leftChild_ = leftChild;
            this.rightChild_ = rightChild;
            this.minimumOffset_ = minimumOffset;
            this.maximumOffset_ = maximumOffset;
            this.parentHeight_ = parentHeight;
            this.tempConditionals_ = tempConditionals;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.offset_ = 0.0;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(0.0, this, this.fracDigits_);
            this.offset_ = MathUtils.ensureBounded(minimiser.minx, this.minimumOffset_, this.maximumOffset_);
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.baseHeight_ + this.offset_;
        }

        public double getOffset() {
            return this.offset_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double offset) {
            this.offset_ = offset;
            double adjustedHeight = this.baseHeight_ + offset;
            ConditionalProbabilityStore left = this.leftChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            ConditionalProbabilityStore right = this.rightChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            ConditionalProbabilityStore descendentExtended = this.internal_.calculateFlatConditionals(this.descendentPattern_, left, right);
            this.external_.calculateSingleAscendentExtendedConditionalsIndirect(this.parentHeight_, adjustedHeight, this.ascendentPattern_, this.ascendentFlat_, this.tempConditionals_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(adjustedHeight, this.centerPattern_, this.tempConditionals_, descendentExtended);
            return result;
        }

        private final void test() {
            ConditionalProbabilityStore left = this.leftChild_.getDescendentExtendedConditionals(this.baseHeight_, this.tool_, false);
            ConditionalProbabilityStore right = this.rightChild_.getDescendentExtendedConditionals(this.baseHeight_, this.tool_, false);
            ConditionalProbabilityStore descendentExtended = this.internal_.calculateFlatConditionals(this.descendentPattern_, left, right);
            this.external_.calculateSingleAscendentExtendedConditionalsIndirect(this.parentHeight_, this.baseHeight_, this.ascendentPattern_, this.ascendentFlat_, this.tempConditionals_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(this.baseHeight_, this.centerPattern_, this.tempConditionals_, descendentExtended);
            System.out.println("Test:" + result);
        }

        public double getLowerBound() {
            return this.minimumOffset_;
        }

        public double getUpperBound() {
            return this.maximumOffset_;
        }
    }

    private static final class LocalShiftPlusOptimisationHandler
    implements UnivariateFunction {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private double height_;
        private ConditionalProbabilityStore ascendentFlat_;
        private ConditionalProbabilityStore leftBaseExtended_;
        private ConditionalProbabilityStore rightBaseExtended_;
        private ConditionalProbabilityStore tempConditionals_;
        private PatternInfo descendentPattern_;
        private PatternInfo ascendentPattern_;
        private PatternInfo centerPattern_;
        private double maxChildHeight_;
        private double parentHeight_;
        private int fracDigits_;

        public LocalShiftPlusOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public void setup(ConditionalProbabilityStore ascendentFlat, PatternInfo ascendentPattern, PatternInfo centerPattern, ConditionalProbabilityStore leftBaseExtended, ConditionalProbabilityStore rightBaseExtended, PatternInfo descendentPattern, double startingHeight, double maxChildHeight, double parentHeight, MolecularClockLikelihoodModel.External external, ConditionalProbabilityStore tempConditionals, int fracDigits) {
            this.height_ = startingHeight;
            this.ascendentFlat_ = ascendentFlat;
            this.ascendentPattern_ = ascendentPattern;
            this.centerPattern_ = centerPattern;
            this.leftBaseExtended_ = leftBaseExtended;
            this.rightBaseExtended_ = rightBaseExtended;
            this.tempConditionals_ = tempConditionals;
            this.descendentPattern_ = descendentPattern;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.parentHeight_ = parentHeight;
            this.maxChildHeight_ = maxChildHeight;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(this.height_, this, this.fracDigits_);
            this.height_ = MathUtils.ensureBounded(minimiser.minx, this.maxChildHeight_, this.parentHeight_);
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.height_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double height) {
            ConditionalProbabilityStore descendentExtended = this.internal_.calculatePostExtendedFlatConditionals(height, this.maxChildHeight_, this.descendentPattern_, this.leftBaseExtended_, this.rightBaseExtended_);
            this.external_.calculateSingleAscendentExtendedConditionalsIndirect(this.parentHeight_, height, this.ascendentPattern_, this.ascendentFlat_, this.tempConditionals_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(height, this.centerPattern_, this.tempConditionals_, descendentExtended);
            return result;
        }

        public double getLowerBound() {
            return this.maxChildHeight_;
        }

        public double getUpperBound() {
            return this.parentHeight_;
        }
    }

    private final class LocalShiftOptimisationHandler
    implements UnivariateFunction {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private double height_;
        private ConditionalProbabilityStore ascendentFlat_;
        private ConditionalProbabilityStore leftBaseExtended_;
        private ConditionalProbabilityStore rightBaseExtended_;
        private ConditionalProbabilityStore tempConditionals_;
        private PatternInfo descendentPattern_;
        private PatternInfo ascendentPattern_;
        private PatternInfo centerPattern_;
        private double maxChildHeight_;
        private double parentHeight_;
        private int fracDigits_;

        public LocalShiftOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public void setup(ConditionalProbabilityStore ascendentFlat, PatternInfo ascendentPattern, PatternInfo centerPattern, ConditionalProbabilityStore leftBaseExtended, ConditionalProbabilityStore rightBaseExtended, PatternInfo descendentPattern, double startingHeight, double maxChildHeight, double parentHeight, MolecularClockLikelihoodModel.External external, ConditionalProbabilityStore tempConditionals, int fracDigits) {
            this.height_ = startingHeight;
            this.ascendentFlat_ = ascendentFlat;
            this.ascendentPattern_ = ascendentPattern;
            this.centerPattern_ = centerPattern;
            this.leftBaseExtended_ = leftBaseExtended;
            this.rightBaseExtended_ = rightBaseExtended;
            this.tempConditionals_ = tempConditionals;
            this.descendentPattern_ = descendentPattern;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.parentHeight_ = parentHeight;
            this.maxChildHeight_ = maxChildHeight;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(this.height_, this, this.fracDigits_);
            this.height_ = MathUtils.ensureBounded(minimiser.minx, this.maxChildHeight_, this.parentHeight_);
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.height_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double height) {
            ConditionalProbabilityStore descendentExtended = this.internal_.calculatePostExtendedFlatConditionals(height, this.maxChildHeight_, this.descendentPattern_, this.leftBaseExtended_, this.rightBaseExtended_);
            this.external_.calculateSingleAscendentExtendedConditionalsIndirect(this.parentHeight_, height, this.ascendentPattern_, this.ascendentFlat_, this.tempConditionals_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(height, this.centerPattern_, this.tempConditionals_, descendentExtended);
            return result;
        }

        public double getLowerBound() {
            return this.maxChildHeight_;
        }

        public double getUpperBound() {
            return this.parentHeight_;
        }
    }
}

