/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.treesearch.AbstractLeafNode;
import pal.treesearch.ConstrainedNode;
import pal.treesearch.ConstraintModel;
import pal.treesearch.FreeBranch;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.HeightInformationUser;
import pal.treesearch.ParentableConstrainedNode;
import pal.treesearch.PivotNode;

public class ConstrainedLeafNode
extends AbstractLeafNode
implements ConstrainedNode {
    private ParentableConstrainedNode parentNode_;
    private final MolecularClockLikelihoodModel.Leaf leafCalculator_;
    private final double originalPeerHeight_;
    private final double height_;

    public ConstrainedLeafNode(ParentableConstrainedNode parentNode, Node peer, double height, GeneralConstructionTool tool, ConstraintModel.GroupManager parentGroup) {
        super(peer.getIdentifier().getName(), tool);
        this.parentNode_ = parentNode;
        this.originalPeerHeight_ = peer.getNodeHeight();
        this.height_ = height;
        this.leafCalculator_ = this.createNewConstrainedLeafCalculator(parentGroup);
    }

    public void recursivelySetParentPivot(PivotNode parentPivot) {
    }

    public void setupInternalNodeHeights(ConstraintModel.GroupManager groupConstraints) {
    }

    public double getMinOriginalDescendentLeafHeight() {
        return this.originalPeerHeight_;
    }

    public double getMaxOriginalDescendentLeafHeight() {
        return this.originalPeerHeight_;
    }

    public ConstrainedNode getLeftChild() {
        return null;
    }

    public ConstrainedNode getRightChild() {
        return null;
    }

    public void recursivelyAdjustNodeHeight(ConstrainedNode.HeightAdjustment heightDelta) {
    }

    public String toStringHeights() {
        return this.getLabel() + ":" + this.height_;
    }

    public String toStringLengths(double parentHeight) {
        return this.getLabel() + ":" + (parentHeight - this.height_);
    }

    public double getMinimumDirectChildDistance() {
        return 0.0;
    }

    public Node buildDescendentPALNodeBase() {
        return NodeFactory.createNode(new Identifier(this.getLabel()), this.getNodeHeight());
    }

    public final Node buildDescendentPALNodeES(ConstraintModel.GroupManager groupManager) {
        return NodeFactory.createNode(new Identifier(this.getLabel()), groupManager.getExpectedSubstitutionHeight(this.getNodeHeight()));
    }

    public final double getMinimumLeafChildSeperation(double parentHeight) {
        return parentHeight - this.height_;
    }

    public void rebuildDescendentPattern(GeneralConstructionTool tool) {
    }

    public PatternInfo getDescendentPatternInfo(GeneralConstructionTool tool) {
        return this.getPatternInfo();
    }

    private final void checkAdd(ArrayList store, Class componentType) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
    }

    public void getSubTreeComponents(ArrayList store, Class componentType) {
        this.checkAdd(store, componentType);
    }

    public void getNonSubTreeComponents(ArrayList store, Class componentType) {
        if (this.parentNode_ != null) {
            this.parentNode_.getNonSubTreeOfChildComponents(store, componentType, this);
        }
    }

    public void getAllComponents(ArrayList store, Class componentType) {
        this.checkAdd(store, componentType);
        this.getNonSubTreeComponents(store, componentType);
    }

    public final double getNodeHeight() {
        return this.height_;
    }

    public double getMinimumChildSeperation(double currentSeperation) {
        return currentSeperation;
    }

    public void obtainLeafInformation(HeightInformationUser user) {
        user.addHeight(this.getLabel(), this.originalPeerHeight_);
    }

    public ConditionalProbabilityStore getDescendentExtendedConditionals(double extensionHeight, GeneralConstructionTool tool, boolean allowCaching) {
        return this.leafCalculator_.calculateExtendedConditionals(extensionHeight, this.height_);
    }

    public ConditionalProbabilityStore getDescendentExtendedConditionalsWithAdjustedInternalHeights(double extensionHeight, GeneralConstructionTool tool, ConstrainedNode.HeightAdjustment internalNodeHeightAdjuster, boolean allowCaching) {
        return this.leafCalculator_.calculateExtendedConditionals(extensionHeight, this.height_);
    }

    public ConditionalProbabilityStore getDescendentFlatConditionals(GeneralConstructionTool tool, boolean allowCaching) {
        return this.leafCalculator_.calculateFlatConditionals(this.height_);
    }

    public void testLikelihood(GeneralConstructionTool tool) {
        System.out.println("Test (C-LEAF:" + this.getLabel() + ")");
    }

    public String toString(FreeBranch caller) {
        return this.getLabel();
    }
}

