/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.treesearch.ConstrainedInternalNode;
import pal.treesearch.ConstrainedLeafNode;
import pal.treesearch.ConstrainedNode;
import pal.treesearch.ConstraintModel;
import pal.treesearch.FreeBranch;
import pal.treesearch.FreeInternalNode;
import pal.treesearch.FreeLeafNode;
import pal.treesearch.FreeNode;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.ParentableConstrainedNode;
import pal.treesearch.PivotNode;
import pal.treesearch.RootAccess;

public class GeneralConstructionTool {
    private final String[] names_;
    private final int[][] sequences_;
    private final int numberOfStates_;
    private final int numberOfSites_;
    private final DataType dataType_;
    private int nextConnectionIndex_ = 0;
    private final ArrayList allUNodes_ = new ArrayList();
    private final ConstraintModel constraints_;
    private ConditionalProbabilityStore tempConditionals_ = null;
    private final UnconstrainedLikelihoodModel.External freeCalcExternal_;

    public GeneralConstructionTool(ConstraintModel constraints, Alignment alignment) {
        this.constraints_ = constraints;
        this.dataType_ = alignment.getDataType();
        this.numberOfSites_ = alignment.getSiteCount();
        this.numberOfStates_ = this.dataType_.getNumStates();
        this.names_ = Identifier.getNames(alignment);
        this.sequences_ = AlignmentUtils.getAlignedStates(alignment, this.numberOfStates_);
        this.freeCalcExternal_ = this.constraints_.createNewFreeExternal();
    }

    public FreeNode createFreeNode(Node peer, FreeBranch parent, GeneralConstraintGroupManager.Store store) {
        if (peer.isLeaf()) {
            String name = peer.getIdentifier().getName();
            int[] sequence = this.getSequence(name);
            String[] leafLabelSet = new String[]{name};
            if (this.constraints_.getGlobalClockConstraintGrouping(leafLabelSet) != null) {
                throw new IllegalArgumentException("Being forced to treat node '" + name + "' as unconstrained when constrained (probably a result of incorrectly structured topology");
            }
            return new FreeLeafNode(parent, name, this);
        }
        String[] leafLabelSet = this.getLeafLabelSet(peer);
        ConstraintModel.GroupManager grouping = this.constraints_.getGlobalClockConstraintGrouping(leafLabelSet);
        if (grouping == null) {
            return new FreeInternalNode(peer, parent, this, store);
        }
        return new PivotNode(peer, parent, this, store.getConstraintGroupManager(grouping), store);
    }

    public RootAccess createRootAccess(Node baseTree, GeneralConstraintGroupManager.Store store) {
        String[] allLeaves = this.getLeafLabelSet(baseTree);
        ConstraintModel.GroupManager grouping = this.constraints_.getGlobalClockConstraintGrouping(allLeaves);
        if (grouping == null) {
            return new FreeBranch(baseTree, this, store);
        }
        return new PivotNode(baseTree, this, store.getConstraintGroupManager(grouping), store);
    }

    public ConstrainedNode createConstrainedNode(Node peer, ParentableConstrainedNode parent, GeneralConstraintGroupManager.Store store, GeneralConstraintGroupManager groupManager) {
        ConstraintModel.GroupManager parentGroup = groupManager.getRelatedGroup();
        if (peer.isLeaf()) {
            String name = peer.getIdentifier().getName();
            int[] sequence = this.getSequence(name);
            String[] leafLabelSet = new String[]{name};
            ConstraintModel.GroupManager grouping = this.constraints_.getGlobalClockConstraintGrouping(leafLabelSet);
            if (grouping == null) {
                throw new IllegalArgumentException("Being forced to treat node '" + name + "' as constrained when unconstrained (probably a result of incorrectly structured topology");
            }
            return new ConstrainedLeafNode(parent, peer, parentGroup.getLeafBaseHeight(name), this, parentGroup);
        }
        String[] leafLabelSet = this.getLeafLabelSet(peer);
        ConstraintModel.GroupManager grouping = this.constraints_.getGlobalClockConstraintGrouping(leafLabelSet);
        if (grouping == null) {
            throw new RuntimeException("Not implemented - cannont handle the constrained moving to unconstrained case yet!");
        }
        return new ConstrainedInternalNode(peer, parent, this, store, groupManager);
    }

    public PatternInfo constructFreshPatternInfo(boolean binaryPattern) {
        return new PatternInfo(this.numberOfSites_, binaryPattern);
    }

    public final ConditionalProbabilityStore obtainTempConditionalProbabilityStore() {
        if (this.tempConditionals_ == null) {
            this.tempConditionals_ = this.newConditionalProbabilityStore(false);
        }
        return this.tempConditionals_;
    }

    public final ConditionalProbabilityStore newConditionalProbabilityStore(boolean isForLeaf) {
        return this.constraints_.createAppropriateConditionalProbabilityStore(isForLeaf);
    }

    public final int allocateNextConnectionIndex() {
        return this.nextConnectionIndex_++;
    }

    public UnconstrainedLikelihoodModel.Internal allocateNewFreeInternalCalculator() {
        return this.constraints_.createNewFreeInternal();
    }

    public UnconstrainedLikelihoodModel.External obtainFreeExternalCalculator() {
        if (this.freeCalcExternal_ != null) {
            return this.freeCalcExternal_;
        }
        throw new RuntimeException("No free calculator");
    }

    public UnconstrainedLikelihoodModel.Leaf createNewFreeLeafCalculator(int[] patternStateMatchup, int numberOfPatterns) {
        return this.constraints_.createNewFreeLeaf(patternStateMatchup, numberOfPatterns);
    }

    public int build(PatternInfo beingBuilt, PatternInfo left, PatternInfo right) {
        return beingBuilt.build(left, right, this.numberOfSites_);
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public final int getNumberOfSites() {
        return this.numberOfSites_;
    }

    public int getNumberOfStates() {
        return this.numberOfStates_;
    }

    public int[] getSequence(String name) {
        if (this.sequences_ == null) {
            return null;
        }
        int i = 0;
        while (i < this.names_.length) {
            if (name.equals(this.names_[i])) {
                return this.sequences_[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown sequence:" + name);
    }

    public String[] getLeafLabelSet(Node peer) {
        ArrayList al = new ArrayList();
        this.getLeafLabelSet(peer, al);
        String[] result = new String[al.size()];
        al.toArray(result);
        return result;
    }

    public void getLeafLabelSet(Node peer, ArrayList al) {
        if (peer.isLeaf()) {
            al.add(peer.getIdentifier().getName());
        } else {
            this.getLeafLabelSet(peer.getChild(0), al);
            this.getLeafLabelSet(peer.getChild(1), al);
        }
    }
}

