/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.math.MersenneTwisterFast;

public class SearcherUtils {
    public static final int createMatchups(int numberOfSites, int numberOfStates, int[] sitePatternMatchup, int[] patternStateMatchup, int[] sequence) {
        int[] stateCount = new int[numberOfStates + 1];
        int[] statePatternMatchup = new int[numberOfStates + 1];
        int uniqueCount = 0;
        int site = 0;
        while (site < numberOfSites) {
            int state = sequence[site];
            if (stateCount[state] == 0) {
                stateCount[state] = 1;
                int pattern = uniqueCount++;
                patternStateMatchup[pattern] = state;
                statePatternMatchup[state] = pattern;
            } else {
                int n = state;
                stateCount[n] = stateCount[n] + 1;
            }
            sitePatternMatchup[site] = statePatternMatchup[state];
            ++site;
        }
        return uniqueCount;
    }

    public static final String[][] split(String[] leafNames, MersenneTwisterFast r) {
        if (leafNames.length == 2) {
            return new String[][]{{leafNames[0]}, {leafNames[1]}};
        }
        int split = r.nextInt(leafNames.length - 2) + 1;
        return new String[][]{SearcherUtils.subset(leafNames, 0, split), SearcherUtils.subset(leafNames, split)};
    }

    private static final String[] subset(String[] array, int starting, int width) {
        String[] subset = new String[width];
        System.arraycopy(array, starting, subset, 0, width);
        return subset;
    }

    private static final String[] subset(String[] array, int starting) {
        return SearcherUtils.subset(array, starting, array.length - starting);
    }
}

