/*
 * Decompiled with CFR 0.152.
 */
package pal.util;

import java.util.ArrayList;
import java.util.List;
import pal.math.MersenneTwisterFast;
import pal.util.DoubleKey;
import pal.util.DoubleKeyCache;

public class DefaultCache
implements DoubleKeyCache {
    ArrayList list;
    int maxSize;
    DoubleKey nearest;
    DoubleKey nearBelow;
    DoubleKey nearAbove;
    double dist;
    double distToBelow;
    double distToAbove;
    int index;
    static MersenneTwisterFast random = new MersenneTwisterFast();

    private DefaultCache(DefaultCache toCopy) {
        this.maxSize = toCopy.maxSize;
        this.list = new ArrayList(this.maxSize);
    }

    public DefaultCache() {
        this(1000);
    }

    public DefaultCache(int maxSize) {
        this.maxSize = maxSize;
        this.list = new ArrayList(maxSize);
    }

    public Object getNearest(double key, double tolerance) {
        SimpleDoubleKey sdk = (SimpleDoubleKey)this.getNearest(new SimpleDoubleKey(key), tolerance);
        if (sdk == null) {
            return null;
        }
        return sdk.getValue();
    }

    public DoubleKey getNearest(DoubleKey d, double tolerance) {
        if (this.list.isEmpty()) {
            return null;
        }
        this.index = DefaultCache.binarySearch(this.list, d);
        if (this.index >= 0) {
            return (DoubleKey)this.list.get(this.index);
        }
        this.index = -this.index - 1;
        if (this.index == 0) {
            this.nearest = (DoubleKey)this.list.get(0);
        } else if (this.index == this.list.size()) {
            this.nearest = (DoubleKey)this.list.get(this.list.size() - 1);
        } else {
            this.nearBelow = (DoubleKey)this.list.get(this.index - 1);
            this.nearAbove = (DoubleKey)this.list.get(this.index);
            this.distToBelow = Math.abs(this.nearBelow.getKey() - d.getKey());
            this.distToAbove = Math.abs(this.nearAbove.getKey() - d.getKey());
            if (this.distToBelow < this.distToAbove) {
                if (this.distToBelow < tolerance) {
                    return this.nearBelow;
                }
                return null;
            }
            if (this.distToAbove < tolerance) {
                return this.nearAbove;
            }
            return null;
        }
        this.dist = Math.abs(this.nearest.getKey() - d.getKey());
        if (this.dist < tolerance) {
            return this.nearest;
        }
        return null;
    }

    public void addDoubleKey(double relatedKey, Object o) {
        this.addDoubleKey(new SimpleDoubleKey(relatedKey, o));
    }

    public void addDoubleKey(DoubleKey d) {
        if (this.list.isEmpty()) {
            this.list.add(d);
        } else {
            this.index = DefaultCache.binarySearch(this.list, d);
            if (this.index >= 0) {
                return;
            }
            this.index = -this.index - 1;
            this.list.add(this.index, d);
            if (this.list.size() > this.maxSize) {
                this.list.remove(this.list.size() - 1);
                this.list.remove(random.nextInt(this.list.size()));
            }
        }
    }

    public void setMaxCacheSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxCacheSize() {
        return this.maxSize;
    }

    public void clearCache() {
        this.list.clear();
    }

    public Object clone() {
        return new DefaultCache(this);
    }

    private static int binarySearch(List list, Object key) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = list.get(mid);
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static class SimpleDoubleKey
    implements DoubleKey {
        double key_;
        Object value_;

        public SimpleDoubleKey(double key, Object value) {
            this.value_ = value;
            this.key_ = key;
        }

        public SimpleDoubleKey(double key) {
            this(key, null);
        }

        public double getKey() {
            return this.key_;
        }

        public Object getValue() {
            return this.value_;
        }

        public int compareTo(Object other) {
            if (other instanceof SimpleDoubleKey) {
                SimpleDoubleKey ok = (SimpleDoubleKey)other;
                if (ok.key_ < this.key_) {
                    return -1;
                }
                if (ok.key_ > this.key_) {
                    return 1;
                }
                return 0;
            }
            throw new RuntimeException("Assertion error ! Object other should be a SimpleDoubleKey");
        }
    }
}

