# Dynamic Web

Simulate niche model with logistic growth and half saturation density/max
consumption functional response.

## Usage

Launch the program, the output is produced in the current directory.

Available options :

* -s INT : total number of species
* -r INT : seed for random number generator
* -i INT : number of global iterations
* -o STR : prefix of output files
* -n INT : number of threads to process iterations in parallel

## Origin

This program was originally written by Amrei Binzer and Christian Guill.

## TO DO

Some output writing is still to be implemented according to the cpp header
comments.

## Random numbers

Dynamicweb uses the GSL lib to generate random numbers. As the GSL RNG (random
number generators) are not thread-proof, we had to declare several RNG to avoid
concurrency problems between threads.  BUT affecting a generator to each thread
makes the final results different between single-threaded and multi-threaded
runs.

In a single-threaded run, only one RNG is used, so its state at the beginning of
an iteration is altered by the previous one.  In a multi-threaded run where each
thread uses one different RNG, an iteration will use the RNG of the thread and
this RNG was altered by the previous iteration done by this thread.

Briefly, what we want is to have *different RNG for each thread* but also to
make results of *single and multi-threaded equivalent*.

To make it work the same in single and multi-thread, we always associate a
different RNG to each iteration. Then it does not matter which thread processes
an iteration, the RNG used is always the same for a given iteration, whether
it's a single or multi-threaded run.

## Tests

A test BASH script can be found in tests directory.

To use it, just go into "tests" directory and launch test.sh :

``` bash
cd tests
./test.sh
```

It checks that no error occurs when launching the program with all linear
combinations of parameters.

Then it checks that multi-thread and output name definition do not produce
errors in output by comparing outputs that should be identical.

## Parallel processing

There are basically two ways to speed things up with dynamicweb binary.

### OpenMP

By setting more than one thread with the "-s" option, iterations are processed
in parallel. It does not affect the result at all. All iteration results are
merged in the result text file in the same order than a sequencial
(single-thread) run.

### Parallelize by parameters

You may launch the program several times with the same parameters but changing
the seed (-r option) to process multiple iterations parallely. The difference
with the OpenMP method is that you will need to merge your results yourself.

## Memory usage

Memory leaks were checked with *valgrind memcheck* tool.

Memory usage through time has been checked with *valgrind massif* tool. It is
stable in time and does not exceed 150KB with "-s 40" option. The memory usage
peak is 160KB for "-s 50". These values are multiplied by the number of thread.

Concurrent access to global variables was checked with *valgrind hellgrind* tool
which underlined some problems perfectly.
