#ifndef DYNAWEB_COMMANDLINEPARSER_HPP
#define DYNAWEB_COMMANDLINEPARSER_HPP

#include<iostream>
#include <iomanip>
#include<string>
#include<vector>
#include<typeinfo>
#include<typeindex>
#include<algorithm>

class CommandLineParser{
    public:
        CommandLineParser (int &argc, char **argv){
            for (int i=1; i < argc; ++i)
                this->_tokens.push_back(std::string(argv[i]));
        }
        template<typename Ttype> Ttype getCmdOption(const std::string &option, const std::string &longoption, Ttype defaultvalue=Ttype()) const{
          std::string s = getCmdOptionCore(option);
          if(s.empty()) s = getCmdOptionCore(longoption);
          if (s.empty())
            return defaultvalue;
          else{
              Ttype value;
              std::istringstream(s)>>value;
              return value;
          }
        }
        bool cmdOptionExists(const std::string &option) const{
            return std::find(this->_tokens.begin(), this->_tokens.end(), option)
                   != this->_tokens.end();
        }
        template<typename Ttype> void printHelpCmdOption(const std::string &option,
							 const std::string &longoption,
							 const std::string &argument,
							 const std::string &message,
							 Ttype defaultvalue=Ttype()) const{
          if(!option.empty() && !longoption.empty())
            std::cout<<std::setw(35)<<std::left<<(option+",  "+longoption+" "+argument)<<message;
          if(!option.empty() && longoption.empty())
            std::cout<<std::setw(35)<<std::left<<(option+" "+argument)<<message;
          if(option.empty() && !longoption.empty())
            std::cout<<std::setw(35)<<std::left<<(longoption+" "+argument)<<message;
          std::ostringstream buffer;
          buffer<<defaultvalue;
          if(!buffer.str().empty()) std::cout<<" [default: "<<buffer.str()<<"]";
          std::cout<<std::endl;
        }
    private:
        std::vector <std::string> _tokens;
        std::string getCmdOptionCore(const std::string &option) const{
            std::vector<std::string>::const_iterator itr;
            itr =  std::find(this->_tokens.begin(), this->_tokens.end(), option);
            if (itr != this->_tokens.end() && ++itr != this->_tokens.end()){
                return *itr;
            }
            return "";
        }
};

#endif /* DYNAWEB_COMMANDLINEPARSER_HPP */
