#ifndef DYNAWEB_GSLCONTAINERBINDING_HPP
#define DYNAWEB_GSLCONTAINERBINDING_HPP

#include<fstream>
#include<sstream>
#include<memory>
#include<LabelIndex.hpp>

template<typename GSLContainerT>
class GSLContainerBinding{
protected:
  GSLContainerT* _container;
  LabelIndex _labelindex;
  void readFile(std::string filename, bool storage);
  virtual void readLine(std::istringstream& linestream, bool storage) = 0;
  virtual void gslAlloc() = 0;
  // Read data from file
  void createFromFile(std::string filename);
  // Copy assignment is forbidden, explicitely declared
  GSLContainerBinding& operator=(const GSLContainerBinding& other) = delete;
  // Copy constructor
  GSLContainerBinding(const GSLContainerBinding<GSLContainerT>& other) = delete;
public:
  // Empty object
  GSLContainerBinding() : _container(NULL), _labelindex() {}
  // Empty object + labelindex
  GSLContainerBinding(const LabelIndex& labelindex) : _container(NULL), _labelindex(labelindex) {}

  // Move constructor
  GSLContainerBinding(GSLContainerBinding<GSLContainerT>&& tmp_other);
  virtual ~GSLContainerBinding() {}
  unsigned int nbSpecies() const {return(_labelindex.size());}
  bool isEmpty() const {return(_container==NULL);}
  GSLContainerT* data() const {return(_container);}
  const LabelIndex& labelIndex() const {return(_labelindex);}
  unsigned int labelToIndex(const std::string label) {return(_labelindex.labelToIndex(label));}
  std::string indexToLabel(unsigned int i) {return(_labelindex.indexToLabel(i));}
  // Move assignment operator (in case of a=b where b is a rvalue [i.e. a temporary object])
  GSLContainerBinding& operator=(GSLContainerBinding&& tmp_other);
};

template<typename GSLContainerT>
GSLContainerBinding<GSLContainerT>::GSLContainerBinding(GSLContainerBinding<GSLContainerT>&& tmp_other)
{
  if (this != &tmp_other){
    _container = tmp_other._container;
    _labelindex = std::move(tmp_other._labelindex);
    tmp_other._container = NULL; // to avoid a further call to gsl*free
  }
}

template<typename GSLContainerT>
GSLContainerBinding<GSLContainerT>& GSLContainerBinding<GSLContainerT>::operator=(GSLContainerBinding<GSLContainerT>&& tmp_other)
{
  if (this != &tmp_other){
      _container = tmp_other._container;
      _labelindex = std::move(tmp_other._labelindex);
      tmp_other._container = NULL; // to avoid a further call to gsl*free
  }
  return(*this);
}

template<typename GSLContainerT>
void GSLContainerBinding<GSLContainerT>::readFile(std::string filename, bool storage){
  std::ifstream edgestream;
  edgestream.open(filename.c_str());
  if (!edgestream.good()){
      std::cerr<<"Error: unable to open file "<<filename<<std::endl;
      exit(1);
  }
  std::string line; getline(edgestream, line);
  while (line.size()){
      std::istringstream linestream(line);
      readLine(linestream, storage);
      line.clear(); getline(edgestream, line);
  }
}

template<typename GSLContainerT>
void GSLContainerBinding<GSLContainerT>::createFromFile(std::string filename)
{
  readFile(filename, false);
  gslAlloc();
  readFile(filename, true);
}

#endif /* DYNAWEB_GSLCONTAINERBINDING_HPP */
