#ifndef DYNAWEB_INTERACTIONMATRIX_HPP
#define DYNAWEB_INTERACTIONMATRIX_HPP

#include<gsl/gsl_matrix.h>
#include <gsl/gsl_blas.h>
#include<iostream>
#include<fstream>
#include<sstream>
#include<string>
#include<map>
#include<vector>
#include<memory>
#include<GSLContainerBinding.hpp>

class InteractionMatrix : public GSLContainerBinding<gsl_matrix>{
protected:
  virtual void readLine(std::istringstream& linestream, bool storage){
    std::string fromi; unsigned int i;
    linestream >> fromi;
    i = labelToIndex(fromi);
    std::string toj; unsigned int j;
    linestream >> toj;
    j = labelToIndex(toj);
    if(storage) gsl_matrix_set(_container,i,j,1.);
  }
  virtual void gslAlloc(){
    _container = gsl_matrix_calloc(nbSpecies(),nbSpecies());
  }
  // Copy assignment is forbidden, explicitely declared
  InteractionMatrix& operator=(const InteractionMatrix& im) = delete;
  // Copy constructor
  InteractionMatrix(const InteractionMatrix& im)
  :  GSLContainerBinding<gsl_matrix>(im._labelindex) {
    gslAlloc();
    gsl_matrix_memcpy(_container,im._container);
  }
public:
  // Empty object
  InteractionMatrix()
  : GSLContainerBinding<gsl_matrix>() {}
  // Read edges list from file
  InteractionMatrix(std::string filename)
  : GSLContainerBinding<gsl_matrix>() {
    createFromFile(filename);
  }
  // Same, but use&update the labels associated to another object
  InteractionMatrix(std::string filename, const LabelIndex& labelindex)
  : GSLContainerBinding<gsl_matrix>(labelindex) {
    createFromFile(filename);
  };
  // Empty matrix with labels associated to another object
  InteractionMatrix(const LabelIndex& labelindex) : GSLContainerBinding<gsl_matrix>(labelindex) {
    gslAlloc();
  }
  // Empty matrix with nbspecies integer-labeled species
  InteractionMatrix(unsigned int nbspecies) : GSLContainerBinding<gsl_matrix>() {
    _labelindex.setLabelsFromIntegers(nbspecies);
    gslAlloc();
  }
  // Move constructor
  InteractionMatrix(InteractionMatrix&& tmp_im)
  : GSLContainerBinding<gsl_matrix>(reinterpret_cast<GSLContainerBinding<gsl_matrix>&&>(tmp_im)) {}
  // Destructor
  virtual ~InteractionMatrix() {if(_container) gsl_matrix_free(_container);}
  // Move assignment operator (in case of a=b where b is a rvalue [i.e. a temporary object])
  InteractionMatrix& operator=(InteractionMatrix&& tmp_im) {
    GSLContainerBinding<gsl_matrix>::operator=(reinterpret_cast<GSLContainerBinding<gsl_matrix>&&>(tmp_im));
    return(*this);
  }
  void rewireWithPreferentialAttachment(const std::string& mode, double thres=0.333);
  friend std::ostream& operator<<(std::ostream& os, const InteractionMatrix& im);
};

inline std::ostream& operator<<(std::ostream& os, const InteractionMatrix& im)
{
  for(unsigned int i=0; i<im.nbSpecies(); i++){
      os<<im._labelindex.indexToLabel(i)<<" ";
      for(unsigned int j=0; j<im.nbSpecies(); j++) os<<gsl_matrix_get(im._container,i,j)<<" ";
      os<<std::endl;
  }
  return os;
}

#endif /* DYNAWEB_INTERACTIONMATRIX_HPP */
