#ifndef DYNAWEB_LABELINDEX_HPP
#define DYNAWEB_LABELINDEX_HPP

#include<iostream>
#include<string>
#include<map>
#include<vector>

class LabelIndex{ // Quasi-singleton class
private:
  std::shared_ptr<std::map<std::string,unsigned int> > _label2index;
  std::shared_ptr<std::vector<std::string> > _labels;
  // Copy assignment is forbidden, explicitely declared
  LabelIndex& operator=(const LabelIndex& other) = delete;
public:
  LabelIndex()
  : _label2index(std::make_shared<std::map<std::string,unsigned int> >(std::map<std::string,unsigned int>())),
    _labels(std::make_shared<std::vector<std::string> >(std::vector<std::string>())) {}
  LabelIndex(const LabelIndex& labelindex)
  : _label2index(labelindex._label2index), _labels(labelindex._labels) {}
  LabelIndex(LabelIndex&& tmp_other){
    std::cerr<<"LabelIndex::move_constr"<<std::endl;
    if (this != &tmp_other){
      _label2index = std::move(tmp_other._label2index);
      _labels = std::move(tmp_other._labels);
      tmp_other._label2index = nullptr;
      tmp_other._labels = nullptr;
    }
  }
  ~LabelIndex() {}
  unsigned int size() const {
    return(_labels->size());
  }
  unsigned int labelToIndex(const std::string label){
    unsigned int index;
    auto itmap = _label2index->find(label);
    if (itmap != _label2index->end())
      index = itmap->second;
    else{
	index = _labels->size();
	_label2index->emplace(label,index);
	_labels->push_back(label);
    }
    return index;
  }
  std::string indexToLabel(unsigned int i) const{
    return(_labels->at(i));
  }
  void setLabelsFromIntegers(unsigned int n){
    *this = LabelIndex();
    for(unsigned int i=1; i<=n; i++){
      _label2index->emplace(std::to_string(i),i);
      _labels->push_back(std::to_string(i));
    }
  }
  // Move assignment operator (in case of a=b where b is a rvalue [i.e. a temporary object])
  LabelIndex& operator=(LabelIndex&& tmp_other){
    if (this != &tmp_other){
      _label2index = std::move(tmp_other._label2index);
      _labels = std::move(tmp_other._labels);
      tmp_other._label2index = nullptr;
      tmp_other._labels = nullptr;
    }
    return(*this);
  }
};

#endif /* DYNAWEB_LABELINDEX_HPP */
