#ifndef DYNAWEB_NONTROPHICMATRIX_HPP
#define DYNAWEB_NONTROPHICMATRIX_HPP

#include<InteractionMatrix.hpp>
#include<ParameterVector.hpp>
#include<gsl/gsl_rng.h>
#include<gsl/gsl_vector.h>
#include <gsl/gsl_blas.h>
#include<math.h>

//#define RELAX

class InterferenceMatrix : public InteractionMatrix{
private:
  void ponderate(ParameterVector& massvec, double i0){
    unsigned int nbspecies = nbSpecies();
    for(unsigned int i=0; i<nbspecies; i++){
	double m_i = gsl_vector_get(massvec.data(),i);
	for(unsigned int j=0; j<nbspecies; j++){
	    double m_j = gsl_vector_get(massvec.data(),j);
	    gsl_matrix_set(_container,i,j,gsl_matrix_get(_container,i,j)*i0/(1+fabs(log(m_i)-log(m_j))));
	    // interference competition is stronger when target and source are more similar in size
	}
    }
  }
public:
  InterferenceMatrix()
  : InteractionMatrix() {}
  InterferenceMatrix(std::string filename, const LabelIndex& labelindex,
		     ParameterVector& massvec, double i0)
  : InteractionMatrix(filename, labelindex) {ponderate(massvec,i0);}
  InterferenceMatrix(const LabelIndex& labelindex) : InteractionMatrix(labelindex) {}
  InterferenceMatrix(const TrophicMatrix& TImat,
		     ParameterVector& basalvec,
		     ParameterVector& sessilevec,
		     ParameterVector& massvec,
		     double pinterference, double i0)
  : InteractionMatrix(TImat.labelIndex()) {
    unsigned int nbspecies = nbSpecies();
    for(unsigned int i=0; i<nbspecies; i++){
#ifndef RELAX
	double ses_i = gsl_vector_get(sessilevec.data(),i);
	double bas_i = gsl_vector_get(basalvec.data(),i);
	gsl_vector_view rowi=gsl_matrix_row(TImat.data(),i); // Stores the row of all the prey of species i
	for(unsigned int j=0; j<nbspecies; j++){
	    double ses_j = gsl_vector_get(sessilevec.data(),j);
	    double bas_j = gsl_vector_get(basalvec.data(),j);
	    if(ses_i || ses_j || bas_i || bas_j )
	      gsl_matrix_set(_container,i,j,0);
	    else
	      if(i!=j){
	    	  gsl_vector_view rowj=gsl_matrix_row(TImat.data(),j); // Stores the row of all the prey of species j
	    	  double crossprod;
	    	  gsl_blas_ddot(&rowi.vector, &rowj.vector, &crossprod);  // crossprod tells if at least one prey in common
	    	  if((crossprod>0) & (gsl_rng_uniform(RNGSingleton::get().rng())<pinterference)){
	    		  gsl_matrix_set(_container,i,j,1);
	    	  }
	      }
	}
#else
	for(unsigned int j=0; j<nbspecies; j++){
	    double bas_j = gsl_vector_get(basalvec.data(),j);
	    if(bas_j || gsl_rng_uniform(RNGSingleton::get().rng()) > pinterference)
		  gsl_matrix_set(_container,i,j,0);
	    else
	     if(i!=j) gsl_matrix_set(_container,i,j,1);
	}
#endif
    }
    ponderate(massvec,i0);
  }
  virtual ~InterferenceMatrix() {}
  InterferenceMatrix& operator=(InterferenceMatrix&& tmp_im) {
    InteractionMatrix::operator=(reinterpret_cast<InteractionMatrix&&>(tmp_im));
    return(*this);
  }
};

class EffectMatrix : public InteractionMatrix{
public:
  EffectMatrix()
  : InteractionMatrix() {}
  EffectMatrix(const LabelIndex& labelindex) : InteractionMatrix(labelindex) {}
  EffectMatrix(std::string filename, const LabelIndex& labelindex, double effect0)
  : InteractionMatrix(filename, labelindex) {
    gsl_matrix_scale(_container,effect0);
  }
  EffectMatrix(const LabelIndex& labelindex,
	       double peffect, double effect0)
  : InteractionMatrix(labelindex) {
    unsigned int nbspecies = nbSpecies();
    for(unsigned int i=0; i<nbspecies; i++){
	    for(unsigned int j=0; j<nbspecies; j++){
		if(gsl_rng_uniform(RNGSingleton::get().rng()) < peffect)
		  if(i!=j) gsl_matrix_set(_container,i,j,effect0);
	    }
	}
  }
  virtual ~EffectMatrix() {}
  EffectMatrix& operator=(EffectMatrix&& tmp_em) {
    InteractionMatrix::operator=(reinterpret_cast<InteractionMatrix&&>(tmp_em));
    return(*this);
  }
};
typedef EffectMatrix PositiveMatrix;
typedef EffectMatrix NegativeMatrix;

class EstablishmentMatrix : public InteractionMatrix{
public:
  EstablishmentMatrix()
  : InteractionMatrix() {}
  EstablishmentMatrix(const LabelIndex& labelindex) : InteractionMatrix(labelindex) {}
  EstablishmentMatrix(std::string filename, const LabelIndex& labelindex, double e0)
  : InteractionMatrix(filename, labelindex) {
    gsl_matrix_scale(_container,e0);
  }
  EstablishmentMatrix(const LabelIndex& labelindex,
		      ParameterVector& basalvec,
		      ParameterVector& sessilevec,
		      double pestablishment, double e0)
  : InteractionMatrix(labelindex) {
    unsigned int nbspecies = nbSpecies();
    for(unsigned int i=0; i<nbspecies; i++){
	for(unsigned int j=0; j<nbspecies; j++){
	    double bas_j = gsl_vector_get(basalvec.data(),j);
	    double ses_j = gsl_vector_get(sessilevec.data(),j);
	    if(ses_j && bas_j && gsl_rng_uniform(RNGSingleton::get().rng()) < pestablishment)
	      if(i!=j) gsl_matrix_set(_container,i,j,e0);
	}
    }
  }
  virtual ~EstablishmentMatrix() {}
  EstablishmentMatrix& operator=(EstablishmentMatrix&& tmp_em) {
    InteractionMatrix::operator=(reinterpret_cast<InteractionMatrix&&>(tmp_em));
    return(*this);
  }
};

class RefugeMatrix : public InteractionMatrix{
public:
  RefugeMatrix()
  : InteractionMatrix() {}
  RefugeMatrix(const LabelIndex& labelindex) : InteractionMatrix(labelindex) {}
  RefugeMatrix(std::string filename, const LabelIndex& labelindex, double r0)
  : InteractionMatrix(filename, labelindex) {
    gsl_matrix_scale(_container,r0);
  }
  RefugeMatrix(const LabelIndex& labelindex,
		     ParameterVector& sessilevec,
		     ParameterVector& predvec,
		     double prefuge, double r0)
  : InteractionMatrix(labelindex) {
    unsigned int nbspecies = nbSpecies();
    for(unsigned int i=0; i<nbspecies; i++){
#ifndef RELAX
	double ses_i = gsl_vector_get(sessilevec.data(),i);
#endif
	for(unsigned int j=0; j<nbspecies; j++){
	    bool isprey_j = bool(gsl_vector_get(predvec.data(),j)>0);
#ifndef RELAX
	    if(ses_i && isprey_j && gsl_rng_uniform(RNGSingleton::get().rng()) < prefuge)
#else
	    if(isprey_j && gsl_rng_uniform(RNGSingleton::get().rng()) < prefuge)
#endif
	      if(i!=j) gsl_matrix_set(_container,i,j,r0);
	}
    }
  }
  virtual ~RefugeMatrix() {}
  RefugeMatrix& operator=(RefugeMatrix&& tmp_rm) {
    InteractionMatrix::operator=(reinterpret_cast<InteractionMatrix&&>(tmp_rm));
    return(*this);
  }
};

class CompetitionMatrix : public InteractionMatrix{
public:
  CompetitionMatrix()
: InteractionMatrix() {}
  CompetitionMatrix(const LabelIndex& labelindex) : InteractionMatrix(labelindex) {}
  CompetitionMatrix(std::string filename, const LabelIndex& labelindex, double c0)
  : InteractionMatrix(filename, labelindex) {
    gsl_matrix_scale(_container,c0);
  }
  CompetitionMatrix(const LabelIndex& labelindex,
		    ParameterVector& basalvec,
		    ParameterVector& sessilevec,
		    double pcompsessile, double pcompmobile,
		    double c0,
		    bool islogistic)
  : InteractionMatrix(labelindex) {
    unsigned int nbspecies = nbSpecies();
#ifndef RELAX
    for(unsigned int i=0; i<nbspecies; i++){
	double ses_i = gsl_vector_get(sessilevec.data(),i);
	for(unsigned int j=0; j<nbspecies; j++){
	    double ses_j = gsl_vector_get(sessilevec.data(),j);
	    if(ses_i && ses_j){
		if(gsl_rng_uniform(RNGSingleton::get().rng()) < pcompsessile)
		  if(i!=j) gsl_matrix_set(_container,i,j,c0);
	    } else{
		if(gsl_rng_uniform(RNGSingleton::get().rng()) < pcompmobile)
		  if(i!=j) gsl_matrix_set(_container,i,j,c0);
	    }
	}
    }
#else
    for(unsigned int i=0; i<nbspecies; i++){
	for(unsigned int j=0; j<nbspecies; j++){
	    if(gsl_rng_uniform(RNGSingleton::get().rng()) < pcompsessile)
	      if(i!=j) gsl_matrix_set(_container,i,j,c0);
	}
    }
#endif
  }
  virtual ~CompetitionMatrix() {}
  CompetitionMatrix& operator=(CompetitionMatrix&& tmp_rm) {
    InteractionMatrix::operator=(reinterpret_cast<InteractionMatrix&&>(tmp_rm));
    return(*this);
  }
  };

#endif
