#ifndef DYNAWEB_ODESOLVER_HPP
#define DYNAWEB_ODESOLVER_HPP

#include<TrophicMatrix.hpp>
#include<NonTrophicMatrix.hpp>


struct ODEParameters{
  unsigned int nbspecies;
  gsl_matrix* A;
  gsl_matrix* H;
  gsl_matrix* I;
  gsl_matrix* P;
  gsl_matrix* N;
  gsl_matrix* R;
  gsl_matrix* E;
  gsl_matrix* C;
  gsl_vector* x_resp;
  gsl_vector* mort;
  gsl_vector* eff;
  gsl_vector* r_plant;
  gsl_vector* k_plant;
  gsl_vector* basal;
  gsl_vector* sessile;
  gsl_vector* mas;
  gsl_vector* cs;
  double hill;
  bool islogistic;
  bool verbose;
};

class ODESolver
{
private:
  // nbspecies
  unsigned int _nbspecies;
  // biomass  densities
  double* _biomass;
  void removeSpecies(TrophicMatrix& TImat);
public:
  ODESolver(unsigned int nbspecies);
  ~ODESolver();
  void initializeBiomasses(gsl_vector* biomass=NULL);
  void run(TrophicMatrix& TImat,
	   InterferenceMatrix& Imat,
	   PositiveMatrix& Pmat,
	   NegativeMatrix& Nmat,
	   RefugeMatrix& Rmat,
	   EstablishmentMatrix& Emat,
	   CompetitionMatrix& Cmat,
	   ParameterVector& basalvec,
	   ParameterVector& sessilevec,
	   ParameterVector& massvec,
	   int tend, int teval,
	   double extinctthres,
	   double hill,
	   bool islogistic,
	   bool verbose,
	   bool isfirst);
  friend std::ostream& operator<<(std::ostream& os, const ODESolver& solver){
    for(unsigned int i=0; i<solver._nbspecies; i++)
      os<<solver._biomass[i]<<" ";
    return(os);
  }
};
#endif
