#ifndef DYNAWEB_PARAMETERVECTOR_HPP
#define DYNAWEB_PARAMETERVECTOR_HPP

#include<gsl/gsl_vector.h>
#include<GSLContainerBinding.hpp>

class ParameterVector : public GSLContainerBinding<gsl_vector>{
protected:
  virtual void readLine(std::istringstream& linestream, bool storage){
    std::string abouti; unsigned int i;
    linestream >> abouti;
    i = labelToIndex(abouti);
    double param;
    linestream >> param;
    if(storage) gsl_vector_set(_container,i,param);
  }
  virtual void gslAlloc(){
    _container = gsl_vector_calloc(nbSpecies());
  }
  // Copy assignment is forbidden, explicitely declared
  ParameterVector& operator=(const ParameterVector& tmp_other) = delete;
  // Copy constructor
  ParameterVector(const ParameterVector& pv)
  : GSLContainerBinding<gsl_vector>(pv._labelindex){
	  gslAlloc();
	  gsl_vector_memcpy(_container,pv._container);
  }
public:
  // Empty object
  ParameterVector()
  : GSLContainerBinding<gsl_vector>() {}
  // Read parameters from file
  ParameterVector(std::string filename)
  : GSLContainerBinding<gsl_vector>() {
    createFromFile(filename);
  }
  // Same, but use&update the labels associated to another ParameterVector
  ParameterVector(std::string filename, const LabelIndex& labelindex)
  : GSLContainerBinding<gsl_vector>(labelindex) {
    createFromFile(filename);
  };
  // Empty vector with labels associated to another object
  ParameterVector(const LabelIndex& labelindex) : GSLContainerBinding<gsl_vector>(labelindex) {
    gslAlloc();
  }
  // Empty vector with nbspecies integer-labeled species
  ParameterVector(unsigned int nbspecies) : GSLContainerBinding<gsl_vector>() {
    _labelindex.setLabelsFromIntegers(nbspecies);
    gslAlloc();
  }
  // Move constructor
  ParameterVector(ParameterVector&& tmp_pv)
  : GSLContainerBinding<gsl_vector>(reinterpret_cast<GSLContainerBinding<gsl_vector>&&>(tmp_pv)) {}
  // Destructor
  virtual ~ParameterVector() {if(_container) gsl_vector_free(_container);}
  // Move assignment operator (in case of a=b where b is a rvalue [i.e. a temporary object])
  ParameterVector& operator=(ParameterVector&& tmp_pv) {
    GSLContainerBinding<gsl_vector>::operator=(reinterpret_cast<GSLContainerBinding<gsl_vector>&&>(tmp_pv));
    return(*this);
  }
  friend std::ostream& operator<<(std::ostream& os, const ParameterVector& pv);
};

inline std::ostream& operator<<(std::ostream& os, const ParameterVector& pv)
{
  for(unsigned int i=0; i<pv.nbSpecies(); i++){
      os<<pv._labelindex.indexToLabel(i)<<" "<<gsl_vector_get(pv._container,i)<<std::endl;
  }
  return os;
}

#endif /* DYNAWEB_PARAMETERVECTOR_HPP */
