#ifndef DYNAWEB_RNGSINGLETON_HPP
#define DYNAWEB_RNGSINGLETON_HPP

#include <gsl/gsl_rng.h>

class RNGSingleton
{
private:
  gsl_rng* _rng;
  static RNGSingleton* _pinstance;
  RNGSingleton(int seed);
public:
  static RNGSingleton& set(int seed=0);
  static RNGSingleton& reset(int seed);
  static RNGSingleton& get();
  ~RNGSingleton();
  gsl_rng* rng() {return _rng;}
};

#endif
