#ifndef DYNAWEB_TROPHICMATRIX_HPP
#define DYNAWEB_TROPHICMATRIX_HPP

#include<InteractionMatrix.hpp>
#include<ParameterVector.hpp>
#include<RNGSingleton.hpp>
#include<gsl/gsl_vector.h>

class TrophicMatrix : public InteractionMatrix
{
private:
  // Creates a niche model and draw the matrix
  void simulateFromNicheModel(double initialconnectance,
			      double topoerror);
  // Checks whether the web is disconnected
  bool isDisconnected();
  // Check if two species are mutually feeding on each other, if so re-assemble the food web
  bool containsMutualFeedingInteractions();
  // Compute connectance
  double connectance();
  // Copy assignment is forbidden, explicitely declared
  TrophicMatrix& operator=(const TrophicMatrix& tm) = delete;
  // Copy constructor
  TrophicMatrix(const TrophicMatrix& tm)
  : InteractionMatrix(tm) {}
public:
  // Empty object
  TrophicMatrix()
  : InteractionMatrix() {}
  // Read edges list from file
  TrophicMatrix(std::string filename)
  : InteractionMatrix(filename) {}
  // Simulated matrix by a niche model with nbspecies integer-labeled species
  TrophicMatrix(unsigned int nbspecies,
		double initialconnectance,
		double topoerror // error percentage of connectance for the topological models
		)
  : InteractionMatrix(nbspecies) {
    simulateFromNicheModel(initialconnectance,topoerror);
  }
  // Move constructor
  TrophicMatrix(TrophicMatrix&& tm)
  : InteractionMatrix(tm) {}
  // Destructor
  virtual ~TrophicMatrix() {}
  // Move assignment operator (in case of a=b where b is a rvalue [i.e. a temporary object])
  TrophicMatrix& operator=(TrophicMatrix&& tmp_tm) {
    InteractionMatrix::operator=(reinterpret_cast<InteractionMatrix&&>(tmp_tm));
    return(*this);
  }
  // Simulate body masses based on trophic levels
  ParameterVector simulateBodyMasses(double expo);
  // Simulate mobility information
  ParameterVector simulateSessility(ParameterVector& basalvec,
				    double psessileplant, double psessileanimal);
  // Set basal vector with 1 if the species is a primary producer, 0 otherwise
  ParameterVector getBasalSpecies(int &nbbasal);
  // Estimation of shortest path of species to their resource
  ParameterVector getTrophicLevel();
  // Estimation of trophic level with error detection based on infinite loops; if error, return empty vector
  ParameterVector getTrophicLevel_Levins();
  // Compute the number of predators for each species
  ParameterVector numberOfPredators();
};
void minTrophicLevel(gsl_matrix *mat, double* TLmin);

#endif
