#include<InteractionMatrix.hpp>
#include<RNGSingleton.hpp>
#include <gsl/gsl_randist.h>
#include <unistd.h> // getpid
#include <algorithm> // min_element, max_element

using namespace std;

void InteractionMatrix::rewireWithPreferentialAttachment(const string& mode, double thres){
  unsigned int nbspecies = nbSpecies();
  gsl_vector * ones = gsl_vector_calloc(nbspecies);
  gsl_vector * degree = gsl_vector_alloc(nbspecies);
  for(unsigned int i=0; i<nbspecies; i++) gsl_vector_set(ones,i,1);
  gsl_matrix * copymat = gsl_matrix_calloc(nbspecies,nbspecies);
  if((mode=="all") || (mode=="in")){
      gsl_blas_dgemv(CblasTrans,1,_container,ones,0,degree);
      //for(unsigned int i=0; i<nbspecies; i++) cerr<<gsl_vector_get(degree,i)<<" ";
      //cerr<<endl;
      unsigned nbit = 1;
      while((*max_element(degree->data, degree->data+nbspecies)<nbspecies*thres)&&(nbit<50)){
	  gsl_matrix_set_zero(copymat);
	  for(unsigned int i=0; i<nbspecies; i++){
	      for(unsigned int j=0; j<nbspecies; j++){
		  if(gsl_matrix_get(_container,i,j)>0){
		      unsigned int istarget[nbspecies];
		      unsigned int target;
		      do{
			  gsl_ran_multinomial(RNGSingleton::get().rng(), nbspecies, 1, degree->data, istarget);
			  target = 0; while(istarget[target]==0) target++;
			  if(target==i) cerr<<"Loops "<<endl;
		      } while(gsl_matrix_get(copymat,i,target)>0 || target==i); // avoid multiedges and loops
		      gsl_matrix_set(copymat,i,target,gsl_matrix_get(_container,i,j));
		      //cerr<<"Replacing "<<j<<" by "<<target<<endl;
		  }
	      }
	  }
	  gsl_matrix_memcpy(_container,copymat);
	  gsl_blas_dgemv(CblasTrans,1,_container,ones,0,degree);
	  //for(unsigned int i=0; i<nbspecies; i++) cerr<<gsl_vector_get(degree,i)<<" ";
	  //cerr<<endl;
	  nbit++;
      }
  }
  //cerr<<endl;
  if((mode=="all") || (mode=="out")){
      gsl_blas_dgemv(CblasNoTrans,1,_container,ones,0,degree);
      //for(unsigned int i=0; i<nbspecies; i++) cerr<<gsl_vector_get(degree,i)<<" ";
      //cerr<<endl;
      unsigned nbit = 1;
      while((*max_element(degree->data, degree->data+nbspecies)<nbspecies*thres)&&(nbit<25)){
	  gsl_matrix_set_zero(copymat);
	  for(unsigned int i=0; i<nbspecies; i++){
	      for(unsigned int j=0; j<nbspecies; j++){
		  if(gsl_matrix_get(_container,i,j)>0){
		      unsigned int issource[nbspecies];
		      unsigned int source;
		      do{
			  gsl_ran_multinomial(RNGSingleton::get().rng(), nbspecies, 1, degree->data, issource);
			  source = 0; while(issource[source]==0) source++;
		      } while(gsl_matrix_get(copymat,source,j)>0|| source==j); // avoid multiedges and loops
		      gsl_matrix_set(copymat,source,j,gsl_matrix_get(_container,i,j));
		      //cerr<<"Replacing "<<i<<" by "<<source<<endl;
		  }
	      }
	  }
	  gsl_matrix_memcpy(_container,copymat);
	  gsl_blas_dgemv(CblasNoTrans,1,_container,ones,0,degree);
	  //for(unsigned int i=0; i<nbspecies; i++) cerr<<gsl_vector_get(degree,i)<<" ";
	  //cerr<<endl;
	  nbit++;
      }
  }

  gsl_vector_free(ones);
  gsl_vector_free(degree);
}
