#include<RNGSingleton.hpp>

RNGSingleton::RNGSingleton(int seed){
  const gsl_rng_type *rng_t;
  gsl_rng_env_setup();
  rng_t = gsl_rng_default;
  _rng = gsl_rng_alloc(rng_t);
  gsl_rng_set(_rng,seed);
}

RNGSingleton& RNGSingleton::set(int seed)
{
  if(!_pinstance) _pinstance = new RNGSingleton(seed);
  return *_pinstance;
}

RNGSingleton& RNGSingleton::get()
{
  return *_pinstance;
}

RNGSingleton& RNGSingleton::reset(int seed){
  gsl_rng_set(_pinstance->_rng,seed);
  return *_pinstance;
}

RNGSingleton::~RNGSingleton()
{
  gsl_rng_free(_rng);
  _pinstance = NULL;
}

RNGSingleton* RNGSingleton::_pinstance = NULL;
