#include<InteractionMatrix.hpp>
#include<RNGSingleton.hpp>
#include<iostream>

int main(int argc, char* argv[]){
  RNGSingleton::set(1);

  InteractionMatrix m1(argv[1]);
  std::cout<<"m1:\n"<<m1<<std::endl;
  if((m1.nbSpecies()==4)
      && (gsl_matrix_get(m1.data(),0,1)==1)
      && (gsl_matrix_get(m1.data(),2,3)==1)
      && (gsl_matrix_get(m1.data(),0,3)==0))
    std::cout<<"testInteractionMatrix1 SUCCESSFUL"<<std::endl;

  InteractionMatrix m2(argv[1], m1.labelIndex());
  std::cout<<"m2:\n"<<m2<<std::endl;
  if((m2.nbSpecies()==4)
      && (gsl_matrix_get(m2.data(),0,1)==1)
      && (gsl_matrix_get(m2.data(),2,3)==1)
      && (gsl_matrix_get(m2.data(),0,3)==0)
  ) std::cout<<"testInteractionMatrix2 SUCCESSFUL"<<std::endl;

  InteractionMatrix m3(4);
  std::cout<<"m3:\n"<<m3<<std::endl;
  if(m3.nbSpecies()==4) std::cout<<"testInteractionMatrix3 SUCCESSFUL"<<std::endl;

  InteractionMatrix m4;
  m4 = InteractionMatrix(argv[1]);
  std::cout<<"m4:\n"<<m4<<std::endl;
  if(m4.nbSpecies()==4) std::cout<<"testInteractionMatrix4 SUCCESSFUL"<<std::endl;

  InteractionMatrix m5;
  m5 = InteractionMatrix(argv[2]);
  m5.rewireWithPreferentialAttachment("all", 0.5);
  std::cout<<"m5:\n"<<m5<<std::endl;
  if(m5.nbSpecies()==50) std::cout<<"testInteractionMatrix5 SUCCESSFUL"<<std::endl;
}
