#include<TrophicMatrix.hpp>
#include<NonTrophicMatrix.hpp>
#include<iostream>
#include<math.h>

int main(int argc, char* argv[]){
  RNGSingleton::set(1);

  TrophicMatrix TImat(5,0.15,10);
  std::cout<<"TImat:\n"<<TImat<<std::endl;
  int nbbasal;
  ParameterVector basalvec = TImat.getBasalSpecies(nbbasal);
  ParameterVector sessilevec = TImat.simulateSessility(basalvec, 0.8, 0.2);
  ParameterVector massvec = TImat.simulateBodyMasses(3.2);
  ParameterVector predvec = TImat.numberOfPredators();

  double pinterference=0.2, ppositive=0.5, pnegative=0.1,
      prefuge=0.1, pestablishment=1.1, pcompsessile=0.9, pcompmobile=0;
  double i0=0.8, p0=0.5, n0=0.5, r0=0.2, e0=0.5, c0=0.2;

  InterferenceMatrix Imat(TImat,
			  basalvec,sessilevec,massvec,
			  pinterference, i0);
  std::cout<<"Imat:\n"<<Imat<<std::endl;
  std::cout<<"testNonTrophicMatrix1 SUCCESSFUL"<<std::endl;

  PositiveMatrix Pmat(TImat.labelIndex(), ppositive, p0);
  std::cout<<"Pmat:\n"<<Pmat<<std::endl;
  std::cout<<"testNonTrophicMatrix2 SUCCESSFUL"<<std::endl;

  NegativeMatrix Nmat(TImat.labelIndex(), pnegative, n0);
  std::cout<<"Nmat:\n"<<Nmat<<std::endl;
  std::cout<<"testNonTrophicMatrix3 SUCCESSFUL"<<std::endl;

  RefugeMatrix Rmat(TImat.labelIndex(), sessilevec, predvec, prefuge, r0);
  std::cout<<"Rmat:\n"<<Rmat<<std::endl;
  std::cout<<"testNonTrophicMatrix4 SUCCESSFUL"<<std::endl;

  EstablishmentMatrix Emat(TImat.labelIndex(),
			   basalvec,sessilevec,
			   pestablishment, e0);
  std::cout<<"Emat:\n"<<Emat<<std::endl;
  std::cout<<"testNonTrophicMatrix5 SUCCESSFUL"<<std::endl;

  CompetitionMatrix Cmat(TImat.labelIndex(),
			  basalvec,sessilevec,
			  pcompsessile, pcompmobile, c0, true);
  std::cout<<"Cmat:\n"<<Cmat<<std::endl;
  std::cout<<"testNonTrophicMatrix6 SUCCESSFUL"<<std::endl;
}


