#include<ParameterVector.hpp>
#include<iostream>
#include <cmath>

int main(int argc, char* argv[]){
  ParameterVector v1(argv[1]);
  std::cout<<"v1:\n"<<v1<<std::endl;
  if((v1.nbSpecies()==4)
      && (std::abs(double(gsl_vector_get(v1.data(),0)-0.1))<1e-7))
    std::cout<<"testParameterVector1 SUCCESSFUL"<<std::endl;

  ParameterVector v2(argv[1], v1.labelIndex());
  std::cout<<"v2:\n"<<v2<<std::endl;
  if((v2.nbSpecies()==4)
      && (std::abs(double(gsl_vector_get(v2.data(),0)-0.1))<1e-7))
    std::cout<<"testParameterVector2 SUCCESSFUL"<<std::endl;

  ParameterVector v3(4);
  std::cout<<"v3:\n"<<v3<<std::endl;
  if(v3.nbSpecies()==4) std::cout<<"testParameterVector3 SUCCESSFUL"<<std::endl;

  ParameterVector v4;
  v4 = ParameterVector(argv[1]);
  std::cout<<"v4:\n"<<v4<<std::endl;
  if(v4.nbSpecies()==4) std::cout<<"testParameterVector4 SUCCESSFUL"<<std::endl;
}


