#include<TrophicMatrix.hpp>
#include<iostream>
#include<math.h>

int main(int argc, char* argv[]){
  RNGSingleton::set(1);

  TrophicMatrix t1;
  t1 = TrophicMatrix(5,0.15,10);
  std::cout<<"t1:\n"<<t1<<std::endl;
  // trophic tree
  // 5->4->3
  //	4->2
  //	4->1
  if((gsl_matrix_get(t1.data(),3,0)==1)
      && (gsl_matrix_get(t1.data(),3,1)==1)
      && (gsl_matrix_get(t1.data(),3,2)==1)
      && (gsl_matrix_get(t1.data(),4,3)==1))
    std::cout<<"testTrophicMatrix1 SUCCESSFUL"<<std::endl;

  int nbbasal;
  ParameterVector basalvec = t1.getBasalSpecies(nbbasal);
  std::cout<<"basalvec:\n"<<basalvec<<std::endl;
  if((gsl_vector_get(basalvec.data(),0)==1)
      &&(gsl_vector_get(basalvec.data(),1)==1)
      &&(gsl_vector_get(basalvec.data(),2)==1)
      &&(gsl_vector_get(basalvec.data(),3)==0)
      &&(gsl_vector_get(basalvec.data(),4)==0)
      && (nbbasal==3))
    std::cout<<"testTrophicMatrix2 SUCCESSFUL"<<std::endl;

  //ParameterVector TLvec = t1.getTrophicLevel();
  ParameterVector TLvec = t1.getTrophicLevel_Levins();
  if(!TLvec.isEmpty()){
      std::cout<<"TLvec:\n"<<TLvec<<std::endl;
      if((gsl_vector_get(TLvec.data(),0)==1)
	  &&(gsl_vector_get(TLvec.data(),1)==1)
	  &&(gsl_vector_get(TLvec.data(),2)==1)
	  &&(gsl_vector_get(TLvec.data(),3)==2)
	  &&(gsl_vector_get(TLvec.data(),4)==3))
	std::cout<<"testTrophicMatrix3 SUCCESSFUL"<<std::endl;
  }
  ParameterVector massvec = t1.simulateBodyMasses(3.2);
  std::cout<<"massvec:\n"<<massvec<<std::endl;
  if((fabs(gsl_vector_get(massvec.data(),0)-1)<1e-10)
      &&(fabs(gsl_vector_get(massvec.data(),1)-1)<1e-10)
      &&(fabs(gsl_vector_get(massvec.data(),2)-1)<1e-10)
      &&(fabs(gsl_vector_get(massvec.data(),3)-3.2)<1e-10)
      &&(fabs(gsl_vector_get(massvec.data(),4)-10.24)<1e-10))
    std::cout<<"testTrophicMatrix4 SUCCESSFUL"<<std::endl;

  ParameterVector sessilevec = t1.simulateSessility(basalvec, 0.8, 0.2);
  std::cout<<"sessilevec:\n"<<sessilevec<<std::endl;
  if((gsl_vector_get(sessilevec.data(),0)==1)
      &&(gsl_vector_get(sessilevec.data(),1)==1)
      &&(gsl_vector_get(sessilevec.data(),2)==1)
      &&(gsl_vector_get(sessilevec.data(),3)==0)
      &&(gsl_vector_get(sessilevec.data(),4)==0))
    std::cout<<"testTrophicMatrix5 SUCCESSFUL"<<std::endl;
}


