/* DBSequence.cc
 *
 * Copyright (C) 2009 CNRS
 *
 * This file is part of BuildFam.
 *
 * Fam is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>
 */
#include<DBSequence.h>
#include <sstream>
#include <fstream>
#include <stdlib.h>

using namespace std;

namespace buildfam {

  DBSequence::DBSequence(const std::string& seqfile, const std::string& partialfile)
  {
    _nbs = loadSeq(seqfile);
    if (partialfile.size())
      _nbp = loadPartial(partialfile);
    else
      _nbp = 0;
  }

  int DBSequence::loadSeq(const std::string& seqfile)
  {
    ifstream seqfstream;
    seqfstream.open(seqfile.c_str());
    if (!seqfstream.good()){
      cerr<<"Error in DBSequence : unable to open file "<<seqfile<<endl;
      exit(1);
    }
  
    // estimation of dbseq size (useless?)
    int nbseq = 0;
    string line; 
    getline(seqfstream,line); 
    while(line.length()){
      nbseq++;
      getline(seqfstream,line);
    }
    seqfstream.clear(); 
    seqfstream.seekg (0, fstream::beg); // rewind

    // all sequences
    _dbseq.reserve(nbseq);
    nbseq = 0;
    getline(seqfstream,line); 
    while(line.length()){
      istringstream linestream(line);    
      Sequence tmpseq;
      string sname;
      linestream>>sname;
      _str2i[sname] = nbseq++;
#ifdef VERBOSE
      _i2str.push_back(sname);
#endif
      if (linestream.eof()){
	cerr<<"Format error in file "<<seqfile<<endl;
	exit(1);
      }	
      else
	linestream>>tmpseq._lg;
      tmpseq._fam = -1;
      tmpseq._indexp = -1;
      _dbseq.push_back(tmpseq);
      // next
      getline(seqfstream,line);
    }
    seqfstream.close();
    return nbseq;
  }

  int DBSequence::loadPartial(const std::string& partialfile)
  {
    // partial sequences
    ifstream partialfstream;
    partialfstream.open(partialfile.c_str());
    if (!partialfstream.good()){
      cerr<<"Error in DBSequence : unable to open file "<<partialfile<<endl;
      exit(1);
    }
  
    mapStringToInt::iterator itend = _str2i.end();
    int currindexp = 0;
    string tmpstr;
    partialfstream>>tmpstr;
    while(tmpstr.length()){
      mapStringToInt::iterator it = _str2i.find(tmpstr);
      if (it!=itend){
	_dbseq[it->second]._indexp = currindexp++;
      }
      tmpstr.clear();
      partialfstream>>tmpstr;
    }	      
    partialfstream.close();
    return currindexp;
  }

}
