/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;

public class DecayingRateModel
extends AbstractBranchRateModel {
    public static final String DECAYING_RATE_MODEL = "decayingRateModel";
    public static final String MUTATION_RATE = "mutationRate";
    public static final String HALF_LIFE = "halfLife";
    public static final String SUBSTITUTION_RATE = "substitutionRate";
    public static final String PROPORTION = "proportion";
    public static final String AVERAGE = "average";
    private final Parameter mutationRateParameter;
    private final Parameter substitutionRateParameter;
    private final Parameter proportionParameter;
    private final Parameter halfLifeParameter;
    private final boolean useAveraging;
    private final double[] rates;
    private boolean ratesCalculated = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("average", false), new ElementRule(TreeModel.class, "The tree model"), new ElementRule("mutationRate", Parameter.class, "The mutation rate parameter", false), new XORRule(new ElementRule("proportion", Parameter.class, "The proportion of neutral mutations", false), new ElementRule("substitutionRate", Parameter.class, "The long-term substitution", false)), new ElementRule("halfLife", Parameter.class, "The half-life of a deleterious mutation", false)};

        @Override
        public String getParserName() {
            return DecayingRateModel.DECAYING_RATE_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getBooleanAttribute(DecayingRateModel.AVERAGE);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(DecayingRateModel.MUTATION_RATE);
            Parameter parameter2 = null;
            Parameter parameter3 = null;
            if (xMLObject.hasChildNamed(DecayingRateModel.PROPORTION)) {
                parameter2 = (Parameter)xMLObject.getElementFirstChild(DecayingRateModel.PROPORTION);
            } else {
                parameter3 = (Parameter)xMLObject.getElementFirstChild(DecayingRateModel.SUBSTITUTION_RATE);
            }
            Parameter parameter4 = (Parameter)xMLObject.getElementFirstChild(DecayingRateModel.HALF_LIFE);
            Logger.getLogger("dr.evomodel").info("Using decaying-rate clock model.");
            return new DecayingRateModel(treeModel, parameter, parameter3, parameter2, parameter4, bl);
        }

        @Override
        public String getParserDescription() {
            return "This element provides a clock model in which the rate of molecular evolution decays to a substitution rate in the past.";
        }

        @Override
        public Class getReturnType() {
            return DecayingRateModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public DecayingRateModel(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, boolean bl) {
        super(DECAYING_RATE_MODEL);
        this.rates = new double[treeModel.getNodeCount()];
        this.addModel(treeModel);
        this.mutationRateParameter = parameter;
        this.substitutionRateParameter = parameter2;
        this.proportionParameter = parameter3;
        this.halfLifeParameter = parameter4;
        this.addVariable(parameter);
        if (parameter3 != null) {
            this.addVariable(parameter3);
        } else {
            this.addVariable(parameter2);
        }
        this.addVariable(parameter4);
        this.useAveraging = bl;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.ratesCalculated = false;
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.ratesCalculated = false;
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.ratesCalculated = false;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (!this.ratesCalculated) {
            double d = this.mutationRateParameter.getParameterValue(0);
            double d2 = this.proportionParameter != null ? d * this.proportionParameter.getParameterValue(0) : this.substitutionRateParameter.getParameterValue(0);
            double d3 = Math.log(2.0) / this.halfLifeParameter.getParameterValue(0);
            this.calculateNodeRates(tree, tree.getRoot(), d, d2, d3);
            this.ratesCalculated = true;
        }
        return this.rates[nodeRef.getNumber()];
    }

    private final double calculateNodeRates(Tree tree, NodeRef nodeRef, double d, double d2, double d3) {
        double d4;
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        double d5 = 0.0;
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            double d6 = this.calculateNodeRates(tree, nodeRef3, d, d2, d3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            d4 = this.calculateNodeRates(tree, nodeRef4, d, d2, d3);
            d5 = this.useAveraging ? (d6 + d4) / 2.0 : (d6 > d4 ? d6 : d4);
        }
        if (nodeRef2 == null) {
            return 0.0;
        }
        double d7 = tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef);
        double d8 = d5 + d7;
        d4 = DecayingRateModel.rateIntegral(d8, d, d2, d3);
        if (d5 > 0.0) {
            d4 -= DecayingRateModel.rateIntegral(d5, d, d2, d3);
        }
        this.rates[nodeRef.getNumber()] = d4 / d7;
        return d8;
    }

    private static double rateIntegral(double d, double d2, double d3, double d4) {
        return d3 * d + (d2 - d3) / d4 * (1.0 - Math.exp(-d4 * d));
    }

    private static double rate(double d, double d2, double d3, double d4) {
        return d3 + (d2 - d3) * Math.exp(-d4 * d);
    }

    public static void main(String[] stringArray) {
        double d = 1.0E-4;
        double d2 = 1.0E-5;
        double d3 = Math.log(2.0) / 1.0;
        double d4 = 1.0E-6;
        for (int i = 0; i < 100; ++i) {
            System.out.println(d4 + "\t" + DecayingRateModel.rate(d4, d, d2, d3) + "\t" + DecayingRateModel.rateIntegral(d4, d, d2, d3) / d4);
            d4 += 1.0;
        }
    }
}

