/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.ILinearModel;
import ec.tstoolkit.arima.Spectrum;
import ec.tstoolkit.maths.linearfilters.IRationalFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.utilities.Ref;

public abstract class AbstractLinearModel
implements ILinearModel {
    private Spectrum spectrum_;
    private AutoCovarianceFunction acgf_;

    protected AbstractLinearModel() {
    }

    protected AbstractLinearModel(AbstractLinearModel m) {
        this.acgf_ = m.acgf_;
        this.spectrum_ = m.spectrum_;
    }

    protected void clearCachedObjects() {
        this.spectrum_ = null;
        this.acgf_ = null;
    }

    protected Object clone() {
        try {
            AbstractLinearModel model = (AbstractLinearModel)super.clone();
            return model;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    @Override
    public AutoCovarianceFunction getAutoCovarianceFunction() {
        if (!this.isStationary()) {
            return null;
        }
        if (this.acgf_ == null) {
            this.acgf_ = this.initAcgf();
        }
        return this.acgf_;
    }

    @Override
    public Spectrum getSpectrum() {
        if (this.spectrum_ == null) {
            this.spectrum_ = this.initSpectrum();
        }
        return this.spectrum_;
    }

    protected AutoCovarianceFunction initAcgf() {
        IRationalFilter rf = this.getFilter();
        Polynomial num = Polynomial.copyOf(rf.getNumerator().getWeights());
        Polynomial denom = Polynomial.copyOf(rf.getDenominator().getWeights());
        Ref<Object> ndenom = new Ref<Object>(null);
        Utilities.stabilize(denom, ndenom);
        return new AutoCovarianceFunction(num, (Polynomial)ndenom.val, this.getInnovationVariance());
    }

    protected Spectrum initSpectrum() {
        IRationalFilter rf = this.getFilter();
        return new Spectrum(SymmetricFilter.createFromFilter(rf.getNumerator()).times(this.getInnovationVariance()), SymmetricFilter.createFromFilter(rf.getDenominator()));
    }
}

