/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.DefaultLikelihoodEvaluation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.eco.DiffuseLikelihood;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.FilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfAlgorithm;
import ec.tstoolkit.ssf.LikelihoodEvaluation;
import ec.tstoolkit.ssf.ResidualsCumulator;
import ec.tstoolkit.ssf.SsfInitializer;
import ec.tstoolkit.ssf.SsfModel;
import ec.tstoolkit.ssf.State;

public class AkfAlgorithm<F extends ISsf>
implements ISsfAlgorithm<F> {
    private boolean m_ssq = false;
    private boolean m_ml = true;
    private boolean m_diffuse = false;

    @Override
    public DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> evaluate(SsfModel<F> instance) {
        SsfModel<F> model = instance;
        FilteringResults frslts = new FilteringResults(true);
        Filter filter = new Filter();
        Object ssf = model.ssf;
        filter.setSsf(ssf);
        int statedim = ssf.getStateDim();
        State state = new State(statedim, true);
        ssf.Pf0(state.P.subMatrix());
        SsfInitializer initializer = new SsfInitializer(0, state);
        filter.setInitializer(initializer);
        if (!filter.process(model.getData(), frslts)) {
            return null;
        }
        double[] yl = frslts.getFilteredData().data(true, true);
        int ndiffuse = ssf.getNonStationaryDim();
        int nx = model.getX() == null ? 0 : model.getX().getColumnsCount();
        DiffuseConcentratedLikelihood ll = new DiffuseConcentratedLikelihood();
        if (ndiffuse > 0 || nx > 0) {
            Matrix xl = new Matrix(yl.length, ndiffuse + nx);
            double[] buffer = new double[model.getData().getCount()];
            DataBlockIterator lcols = xl.columns();
            if (ndiffuse > 0) {
                Matrix dconst = new Matrix(statedim, ndiffuse);
                ssf.diffuseConstraints(dconst.subMatrix());
                DataBlockIterator dcols = dconst.columns();
                DataBlock dcol = dcols.getData();
                DataBlock lcol = lcols.getData();
                double[] start = new double[statedim];
                do {
                    dcol.copyTo(start, 0);
                    frslts.getVarianceFilter().process(frslts.getFilteredData(), 0, buffer, start);
                    lcol.copy(new DataBlock(frslts.getFilteredData().data(true, true)));
                } while (lcols.next() && dcols.next());
            }
            if (nx > 0) {
                DataBlockIterator cols = model.getX().columns();
                DataBlock col = cols.getData();
                DataBlock lcol = lcols.getData();
                do {
                    col.copyTo(buffer, 0);
                    frslts.getVarianceFilter().process(frslts.getFilteredData(), 0, buffer, null);
                    lcol.copy(new DataBlock(frslts.getFilteredData().data(true, true)));
                } while (lcols.next() && cols.next());
            }
            Householder qr = new Householder(false);
            qr.decompose(xl);
            DataBlock res = new DataBlock(xl.getRowsCount() - xl.getColumnsCount());
            double[] b = new double[xl.getColumnsCount()];
            qr.leastSquares(new DataBlock(yl), new DataBlock(b), res);
            double ssqerr = res.ssq();
            Matrix u = UpperTriangularMatrix.inverse(qr.getR());
            int n = model.getData().getObsCount();
            int d = 0;
            if (this.m_diffuse) {
                d = ndiffuse;
            }
            if (model.getDiffuseX() != null) {
                d += model.getDiffuseX().length;
            }
            double sig = ssqerr / (double)(n - d);
            Matrix bvar = SymmetricMatrix.XXt(u);
            bvar.mul(sig);
            double lddet = 0.0;
            if (d > 0) {
                int i;
                DataBlock rdiag = qr.getRDiagonal();
                int j = 0;
                if (ndiffuse > 0 && this.m_diffuse) {
                    for (i = 0; i < ndiffuse; ++i) {
                        lddet += Math.log(Math.abs(rdiag.get(i)));
                    }
                    j = ndiffuse;
                }
                if (model.getDiffuseX() != null) {
                    for (i = 0; i < model.getDiffuseX().length; ++i) {
                        lddet += Math.log(Math.abs(rdiag.get(j + model.getDiffuseX()[i])));
                    }
                }
                lddet *= 2.0;
            }
            ll.set(ssqerr, frslts.getLogDeterminant(), lddet, n, d);
            ll.setRes(res.getData());
            ll.setB(b, bvar, qr.getRank());
        } else {
            LikelihoodEvaluation.evaluate((ResidualsCumulator)frslts, (DiffuseLikelihood)ll);
        }
        DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> rslt = new DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood>(ll);
        rslt.useLogLikelihood(!this.m_ssq);
        rslt.useML(this.m_ml);
        return rslt;
    }

    public boolean isUsingDiffuseInitialization() {
        return this.m_diffuse;
    }

    public boolean isUsingML() {
        return this.m_ml;
    }

    public boolean isUsingSsq() {
        return this.m_ssq;
    }

    public void useDiffuseInitialization(boolean value) {
        this.m_diffuse = value;
    }

    public void useML(boolean value) {
        this.m_ml = value;
    }

    public void useSsq(boolean value) {
        this.m_ssq = value;
    }
}

