/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.net;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.core.Randomize;

public class Parameters {
    public int[] Nhidden;
    public int Noutputs;
    public int Ninputs;
    public int n_train_patterns;
    public int n_val_patterns;
    public int n_test_patterns;
    public int cycles;
    public int Nhidden_layers;
    public boolean test_data;
    public boolean val_data;
    public boolean cross_validation;
    public boolean tipify_inputs;
    public boolean verbose;
    public boolean save;
    public double eta;
    public double alpha;
    public double lambda;
    public double improve;
    public double threshold;
    public long seed;
    public String train_file;
    public String test_file;
    public String train_output;
    public String test_output;
    public String model_output;
    public String val_file;
    public String val_output;
    public String problem;
    public String bp_type;
    public String[] transfer;

    public void LoadParameters(String file_name) {
        int i;
        int pos2;
        Properties props = new Properties();
        try {
            FileInputStream paramsFile = new FileInputStream(file_name);
            props.load(paramsFile);
            ((InputStream)paramsFile).close();
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception.");
            System.exit(0);
        }
        this.Nhidden_layers = Integer.parseInt(props.getProperty("Hidden_layers"));
        this.Nhidden = new int[this.Nhidden_layers + 1];
        String line = props.getProperty("Hidden_nodes");
        int j = 0;
        int pos1 = 0;
        do {
            if ((pos2 = line.indexOf(" ", pos1)) != -1) {
                this.Nhidden[j] = Integer.parseInt(line.substring(pos1, pos2));
                pos1 = pos2 + 1;
                ++j;
                continue;
            }
            this.Nhidden[j] = Integer.parseInt(line.substring(pos1));
            ++j;
        } while (pos2 != -1 && j < this.Nhidden_layers);
        for (i = j; i < this.Nhidden_layers - 1; ++i) {
            this.Nhidden[i] = this.Nhidden[j - 1];
        }
        this.Nhidden[this.Nhidden_layers - 1] = Integer.parseInt(line.substring(pos1));
        this.eta = Double.parseDouble(props.getProperty("Eta"));
        this.alpha = Double.parseDouble(props.getProperty("Alpha"));
        this.lambda = Double.parseDouble(props.getProperty("Lambda"));
        this.transfer = new String[this.Nhidden_layers + 1];
        line = props.getProperty("Transfer");
        pos1 = 0;
        j = 0;
        do {
            if ((pos2 = line.indexOf(" ", pos1)) != -1) {
                this.transfer[j] = line.substring(pos1, pos2);
                pos1 = pos2 + 1;
                ++j;
                continue;
            }
            this.transfer[j] = line.substring(pos1);
            ++j;
        } while (pos2 != -1 && j < this.Nhidden_layers);
        for (i = j; i < this.Nhidden_layers; ++i) {
            this.transfer[i] = this.transfer[j - 1];
        }
        this.transfer[this.Nhidden_layers] = line.substring(pos1);
        this.test_data = Boolean.valueOf(props.getProperty("Test_data"));
        this.val_data = Boolean.valueOf(props.getProperty("Validation_data"));
        line = props.getProperty("inputData");
        pos1 = line.indexOf("\"", 0);
        pos2 = line.indexOf("\"", pos1 + 1);
        this.train_file = line.substring(pos1 + 1, pos2);
        pos1 = line.indexOf("\"", pos2 + 1);
        pos2 = line.indexOf("\"", pos1 + 1);
        this.val_file = line.substring(pos1 + 1, pos2);
        pos1 = line.indexOf("\"", pos2 + 1);
        pos2 = line.indexOf("\"", pos1 + 1);
        this.test_file = line.substring(pos1 + 1, pos2);
        line = props.getProperty("outputData");
        pos1 = line.indexOf("\"", 0);
        pos2 = line.indexOf("\"", pos1 + 1);
        this.train_output = line.substring(pos1 + 1, pos2);
        pos1 = line.indexOf("\"", pos2 + 1);
        pos2 = line.indexOf("\"", pos1 + 1);
        this.test_output = line.substring(pos1 + 1, pos2);
        pos1 = line.indexOf("\"", pos2 + 1);
        pos2 = line.indexOf("\"", pos1 + 1);
        this.model_output = line.substring(pos1 + 1, pos2);
        this.cross_validation = Boolean.valueOf(props.getProperty("Crossvalidation"));
        this.cycles = Integer.parseInt(props.getProperty("Cycles"));
        this.improve = Double.parseDouble(props.getProperty("Improve"));
        this.seed = Long.parseLong(props.getProperty("seed"));
        if (this.seed != -1L) {
            Randomize.setSeed(this.seed);
        }
        this.problem = props.getProperty("Problem");
        this.bp_type = "BPstd";
        this.tipify_inputs = Boolean.valueOf(props.getProperty("Tipify_inputs"));
        this.verbose = Boolean.valueOf(props.getProperty("Verbose"));
        this.save = Boolean.valueOf(props.getProperty("SaveAll"));
        this.TestParameters();
    }

    private void TestParameters() {
        if (this.eta < 0.0 || this.alpha < 0.0 || this.lambda < 0.0) {
            System.out.println("Negative learning coefficients");
            System.exit(1);
        }
        if (this.cross_validation && !this.val_data) {
            System.out.println("Cross validation without validation data");
            System.exit(1);
        }
        if (this.cycles < 0) {
            System.out.println("Invalid negative values");
            System.exit(1);
        }
        if (this.bp_type.compareToIgnoreCase("BPstd") != 0 && this.bp_type.compareToIgnoreCase("BPmax") != 0) {
            System.out.println("Not a valid bp type");
            System.exit(1);
        }
        for (int i = 0; i < this.Nhidden_layers + 1; ++i) {
            if (this.transfer[i].compareToIgnoreCase("Log") == 0 || this.transfer[i].compareToIgnoreCase("Lin") == 0 || this.transfer[i].compareToIgnoreCase("Htan") == 0) continue;
            System.out.println("Transfer function not valid");
            System.exit(1);
        }
    }
}

