/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Selection.CNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import org.core.Fichero;
import org.core.Randomize;

public class CNN
extends Metodo {
    private long semilla;
    private int k;

    public CNN(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        int l;
        int j;
        int[] clasesS;
        boolean[][] conjM;
        int[][] conjN;
        double[][] conjR;
        double[][] conjS;
        boolean continuar;
        int pos;
        int i;
        long tiempo = System.currentTimeMillis();
        int[] S = new int[this.datosTrain.length];
        for (i = 0; i < S.length; ++i) {
            S[i] = Integer.MAX_VALUE;
        }
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        int tamS = 0;
        if (++nClases < 2) {
            System.err.println("Input dataset is empty");
            nClases = 0;
        }
        Randomize.setSeed(this.semilla);
        for (i = 0; i < nClases; ++i) {
            int cont;
            pos = Randomize.Randint(0, this.clasesTrain.length - 1);
            for (cont = 0; this.clasesTrain[pos] != i && cont < this.clasesTrain.length; ++cont) {
                pos = (pos + 1) % this.clasesTrain.length;
            }
            if (cont >= this.clasesTrain.length) continue;
            S[tamS] = pos;
            ++tamS;
        }
        do {
            continuar = false;
            int[] baraje = new int[this.datosTrain.length];
            for (i = 0; i < this.datosTrain.length; ++i) {
                baraje[i] = i;
            }
            for (i = 0; i < this.datosTrain.length; ++i) {
                pos = Randomize.Randint(i, this.clasesTrain.length - 1);
                int tmp = baraje[i];
                baraje[i] = baraje[pos];
                baraje[pos] = tmp;
            }
            for (i = 0; i < this.datosTrain.length; ++i) {
                int claseObt;
                conjS = new double[tamS][this.datosTrain[0].length];
                conjR = new double[tamS][this.datosTrain[0].length];
                conjN = new int[tamS][this.datosTrain[0].length];
                conjM = new boolean[tamS][this.datosTrain[0].length];
                clasesS = new int[tamS];
                for (j = 0; j < tamS; ++j) {
                    for (l = 0; l < this.datosTrain[0].length; ++l) {
                        conjS[j][l] = this.datosTrain[S[j]][l];
                        conjR[j][l] = this.realTrain[S[j]][l];
                        conjN[j][l] = this.nominalTrain[S[j]][l];
                        conjM[j][l] = this.nulosTrain[S[j]][l];
                    }
                    clasesS[j] = this.clasesTrain[S[j]];
                }
                Arrays.sort(S);
                int busq = Arrays.binarySearch(S, baraje[i]);
                if (busq >= 0 || (claseObt = KNN.evaluacionKNN(this.k, conjS, conjR, conjN, conjM, clasesS, this.datosTrain[baraje[i]], this.realTrain[baraje[i]], this.nominalTrain[baraje[i]], this.nulosTrain[baraje[i]], nClases, this.distanceEu)) == this.clasesTrain[baraje[i]]) continue;
                continuar = true;
                S[tamS] = baraje[i];
                ++tamS;
            }
        } while (continuar);
        conjS = new double[tamS][this.datosTrain[0].length];
        conjR = new double[tamS][this.datosTrain[0].length];
        conjN = new int[tamS][this.datosTrain[0].length];
        conjM = new boolean[tamS][this.datosTrain[0].length];
        clasesS = new int[tamS];
        for (j = 0; j < tamS; ++j) {
            for (l = 0; l < this.datosTrain[0].length; ++l) {
                conjS[j][l] = this.datosTrain[S[j]][l];
                conjR[j][l] = this.realTrain[S[j]][l];
                conjN[j][l] = this.nominalTrain[S[j]][l];
                conjM[j][l] = this.nulosTrain[S[j]][l];
            }
            clasesS[j] = this.clasesTrain[S[j]];
        }
        System.out.println("CNN " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate(this.datosTrain[i], conjS, nClases, clasesS, this.k);
        }
        KNN.writeOutput(this.ficheroSalida[0], trainRealClass, trainPrediction, this.entradas, this.salida, this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate(this.datosTest[i], conjS, nClases, clasesS, this.k);
        }
        KNN.writeOutput(this.ficheroSalida[1], realClass, prediction, this.entradas, this.salida, this.relation);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.semilla = Long.parseLong(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

