/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;

public class SimpleStatistics {
    public double count = 0.0;
    public double sum = 0.0;
    public double sumSq = 0.0;
    public double stdDev = Double.NaN;
    public double mean = Double.NaN;
    public double min = Double.NaN;
    public double max = Double.NaN;

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double n) {
        this.sum += value * n;
        this.sumSq += value * value * n;
        this.count += n;
        if (Double.isNaN(this.min)) {
            this.min = this.max = value;
        } else if (value < this.min) {
            this.min = value;
        } else if (value > this.max) {
            this.max = value;
        }
    }

    public void subtract(double value) {
        this.subtract(value, 1.0);
    }

    public void subtract(double value, double n) {
        this.sum -= value * n;
        this.sumSq -= value * value * n;
        this.count -= n;
    }

    public void calculateDerived() {
        this.mean = Double.NaN;
        this.stdDev = Double.NaN;
        if (this.count > 0.0) {
            this.mean = this.sum / this.count;
            this.stdDev = Double.POSITIVE_INFINITY;
            if (this.count > 1.0) {
                this.stdDev = this.sumSq - this.sum * this.sum / this.count;
                this.stdDev /= this.count - 1.0;
                if (this.stdDev < 0.0) {
                    this.stdDev = 0.0;
                }
                this.stdDev = Math.sqrt(this.stdDev);
            }
        }
    }

    public String toString() {
        this.calculateDerived();
        return "Count   " + M5StaticUtils.doubleToString(this.count, 8) + '\n' + "Min     " + M5StaticUtils.doubleToString(this.min, 8) + '\n' + "Max     " + M5StaticUtils.doubleToString(this.max, 8) + '\n' + "Sum     " + M5StaticUtils.doubleToString(this.sum, 8) + '\n' + "SumSq   " + M5StaticUtils.doubleToString(this.sumSq, 8) + '\n' + "Mean    " + M5StaticUtils.doubleToString(this.mean, 8) + '\n' + "StdDev  " + M5StaticUtils.doubleToString(this.stdDev, 8) + '\n';
    }

    public static void main(String[] args) {
        try {
            String line;
            SimpleStatistics ps = new SimpleStatistics();
            LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("@") || line.startsWith("%")) continue;
                StringTokenizer s = new StringTokenizer(line, " ,\t\n\r\f");
                int count = 0;
                double v1 = 0.0;
                while (s.hasMoreTokens()) {
                    double val = new Double(s.nextToken());
                    if (count != 0) {
                        System.err.println("MSG: Too many values in line \"" + line + "\", skipped.");
                        break;
                    }
                    v1 = val;
                    ++count;
                }
                if (count != true) continue;
                ps.add(v1);
            }
            ps.calculateDerived();
            System.err.println(ps);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

