/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class InstanceParser {
    private BufferedReader br;
    private boolean isTrain;
    private int attributeCount;
    private String header;
    private String relation;
    static int lineCounter;

    public InstanceParser(String fileName, boolean _isTrain) {
        try {
            this.br = new BufferedReader(new FileReader(fileName));
            lineCounter = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.isTrain = _isTrain;
        this.attributeCount = 0;
    }

    public String getHeader() {
        return this.header;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getInstance() {
        return this.getLine();
    }

    public int getAttributeNum() {
        return this.attributeCount;
    }

    public String getLine() {
        String st = null;
        do {
            try {
                st = this.br.readLine();
                ++lineCounter;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } while (st != null && (st.startsWith("%") || st.equals("")));
        return st;
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (IOException e) {
            System.err.println("Error: the instance parser could not be closed. Exiting now.");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

