/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.reification.PropXeqCReif;
import org.chocosolver.solver.constraints.reification.PropXeqYCReif;
import org.chocosolver.solver.constraints.reification.PropXinSReif;
import org.chocosolver.solver.constraints.reification.PropXltCReif;
import org.chocosolver.solver.constraints.reification.PropXltYCReif;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public interface IReificationFactory
extends ISelf<Model> {
    default public void ifThenElse(Constraint ifCstr, Constraint thenCstr, Constraint elseCstr) {
        this.ifThenElse(ifCstr.reify(), thenCstr, elseCstr);
    }

    default public void ifThenElse(BoolVar ifVar, Constraint thenCstr, Constraint elseCstr) {
        this.ifThen(ifVar, thenCstr);
        this.ifThen(ifVar.not(), elseCstr);
    }

    default public void ifThen(Constraint ifCstr, Constraint thenCstr) {
        this.ifThen(ifCstr.reify(), thenCstr);
    }

    default public void ifThen(BoolVar ifVar, Constraint thenCstr) {
        if (ifVar.contains(1)) {
            if (ifVar.isInstantiated()) {
                thenCstr.post();
            } else if (thenCstr.isSatisfied() == ESat.FALSE) {
                ((Model)this.ref()).arithm((IntVar)ifVar, "=", 0).post();
            } else {
                ((Model)this.ref()).arithm((IntVar)ifVar, "<=", thenCstr.reify()).post();
            }
        }
    }

    default public void ifOnlyIf(Constraint cstr1, Constraint cstr2) {
        this.reification(cstr1.reify(), cstr2);
    }

    default public void reification(BoolVar var, Constraint cstr) {
        ESat entail = cstr.isSatisfied();
        if (var.isInstantiatedTo(1)) {
            cstr.post();
        } else if (var.isInstantiatedTo(0)) {
            cstr.getOpposite().post();
        } else if (entail == ESat.TRUE) {
            ((Model)this.ref()).arithm((IntVar)var, "=", 1).post();
        } else if (entail == ESat.FALSE) {
            ((Model)this.ref()).arithm((IntVar)var, "=", 0).post();
        } else {
            cstr.reifyWith(var);
        }
    }

    default public void reifyXeqC(IntVar X, int C, BoolVar B) {
        if (((Model)this.ref()).getSolver().getSearchState() == SearchState.NEW) {
            if (X.isInstantiatedTo(C)) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 1).post();
                return;
            }
            if (!X.contains(C)) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 0).post();
                return;
            }
        }
        ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXeqCReif(X, C, B)));
    }

    default public void reifyXneC(IntVar X, int C, BoolVar B) {
        this.reifyXeqC(X, C, B.not());
    }

    default public void reifyXeqY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXeqC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXeqC(X, Y.getValue(), B);
        } else {
            ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXeqYCReif(X, Y, 0, B)));
        }
    }

    default public void reifyXneY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXneC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXneC(X, Y.getValue(), B);
        } else {
            this.reifyXeqY(X, Y, B.not());
        }
    }

    default public void reifyXeqYC(IntVar X, IntVar Y, int C, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXeqC(Y, X.getValue() - C, B);
        } else if (Y.isAConstant()) {
            this.reifyXeqC(X, Y.getValue() + C, B);
        } else {
            ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXeqYCReif(X, Y, C, B)));
        }
    }

    default public void reifyXneYC(IntVar X, IntVar Y, int C, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXneC(Y, X.getValue() - C, B);
        } else if (Y.isAConstant()) {
            this.reifyXneC(X, Y.getValue() + C, B);
        } else {
            this.reifyXeqYC(X, Y, C, B.not());
        }
    }

    default public void reifyXltC(IntVar X, int C, BoolVar B) {
        if (((Model)this.ref()).getSolver().getSearchState() == SearchState.NEW) {
            if (X.getUB() < C) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 1).post();
                return;
            }
            if (X.getLB() >= C) {
                ((Model)this.ref()).arithm((IntVar)B, "=", 0).post();
                return;
            }
        }
        ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXltCReif(X, C, B)));
    }

    default public void reifyXgtC(IntVar X, int C, BoolVar B) {
        this.reifyXltC(X, C + 1, B.not());
    }

    default public void reifyXltY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXgtC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXltC(X, Y.getValue(), B);
        } else {
            this.reifyXltYC(X, Y, 0, B);
        }
    }

    default public void reifyXgtY(IntVar X, IntVar Y, BoolVar B) {
        this.reifyXltYC(X, Y, 1, B.not());
    }

    default public void reifyXleY(IntVar X, IntVar Y, BoolVar B) {
        this.reifyXltYC(X, Y, 1, B);
    }

    default public void reifyXgeY(IntVar X, IntVar Y, BoolVar B) {
        this.reifyXltYC(X, Y, 0, B.not());
    }

    default public void reifyXltYC(IntVar X, IntVar Y, int C, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXgtC(Y, X.getValue() - C, B);
        } else if (Y.isAConstant()) {
            this.reifyXltC(X, Y.getValue() + C, B);
        } else {
            ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXltYCReif(X, Y, C, B)));
        }
    }

    default public void reifyXgtYC(IntVar X, IntVar Y, int C, BoolVar B) {
        this.reifyXltYC(X, Y, C + 1, B.not());
    }

    default public void reifyXinS(IntVar X, IntIterableRangeSet S, BoolVar B) {
        ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXinSReif(X, S, B)));
    }

    default public void reifyXnotinS(IntVar X, IntIterableRangeSet S, BoolVar B) {
        ((Model)this.ref()).post(new Constraint("BASIC_REIF", new PropXinSReif(X, S, B.not())));
    }
}

