/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.grid.neighborhood.regular.square;

import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.restopt.grid.neighborhood.INeighborhood;
import org.restopt.grid.regular.square.RegularSquareGrid;

public class KWideFourConnected<T extends RegularSquareGrid>
implements INeighborhood<T> {
    private int k;

    public KWideFourConnected(int k) {
        this.k = k;
    }

    @Override
    public int[] getNeighbors(T grid, int i) {
        int[] c = ((RegularSquareGrid)grid).getCoordinatesFromIndex(i);
        return KWideFourConnected.discreteDisk(c[1], c[0], this.k, grid).toArray();
    }

    public static ISet discreteDisk(int x_centre, int y_centre, int k, RegularSquareGrid grid) {
        IntIterableRangeSet s = (IntIterableRangeSet)SetFactory.makeRangeSet();
        for (int i = 1; i <= k; ++i) {
            s.addAll((IntIterableRangeSet)KWideFourConnected.discreteCircle(x_centre, y_centre, i, grid));
        }
        return s;
    }

    private static boolean inGrid(int row, int col, RegularSquareGrid grid) {
        return row >= 0 && row < grid.getNbRows() && col >= 0 && col < grid.getNbCols();
    }

    public static ISet discreteCircle(int x_centre, int y_centre, int r, RegularSquareGrid grid) {
        ISet pixels = SetFactory.makeRangeSet();
        int x = 0;
        int y = r;
        int d = r - 1;
        while (y >= x) {
            int[][] points;
            for (int[] p : points = new int[][]{{y_centre + y, x_centre + x}, {y_centre + x, x_centre + y}, {y_centre + y, x_centre - x}, {y_centre + x, x_centre - y}, {y_centre - y, x_centre + x}, {y_centre - x, x_centre + y}, {y_centre - y, x_centre - x}, {y_centre - x, x_centre - y}}) {
                if (!KWideFourConnected.inGrid(p[0], p[1], grid)) continue;
                pixels.add(grid.getIndexFromCoordinates(p[0], p[1]));
            }
            if (d >= 2 * x) {
                d -= 2 * x + 1;
                ++x;
                continue;
            }
            if (d < 2 * (r - y)) {
                d += 2 * y - 1;
                --y;
                continue;
            }
            d += 2 * (y - x - 1);
            --y;
            ++x;
        }
        return pixels;
    }
}

