/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import blbutil.FileUtil;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import vcf.GL;
import vcf.Marker;

public class GenotypeCorrection {
    private static final String headerLine = "MARKER\tSAMPLE\tREF\tALT\tINPUT_GT\tESTIMATED_GT";

    private GenotypeCorrection() {
    }

    public static void run(List<HapPair> list, GL gL, long l) {
        Random random = new Random(l);
        int[] nArray = new int[gL.nMarkers()];
        int[] nArray2 = new int[gL.nMarkers()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            HapPair hapPair = list.get(i);
            GenotypeCorrection.checkMarkersAndSamples(hapPair, gL);
            List<Edit> list2 = GenotypeCorrection.getEdits(hapPair, gL, random);
            HapPair hapPair2 = GenotypeCorrection.updatedHapPair(hapPair, list2, nArray, nArray2);
            list.set(i, hapPair2);
        }
    }

    public static void run(List<HapPair> list, GL gL, long l, File file, boolean bl) {
        Random random = new Random(l);
        int[] nArray = new int[gL.nMarkers()];
        int[] nArray2 = new int[gL.nMarkers()];
        try (PrintWriter printWriter = FileUtil.printWriter(file, bl);){
            if (!bl) {
                printWriter.println(headerLine);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                HapPair hapPair = list.get(i);
                GenotypeCorrection.checkMarkersAndSamples(hapPair, gL);
                List<Edit> list2 = GenotypeCorrection.getEdits(hapPair, gL, random);
                for (Edit edit : list2) {
                    printWriter.println(edit);
                }
                HapPair hapPair2 = GenotypeCorrection.updatedHapPair(hapPair, list2, nArray, nArray2);
                list.set(i, hapPair2);
            }
        }
    }

    private static void checkMarkersAndSamples(HapPair hapPair, GL gL) {
        if (!hapPair.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!hapPair.samples().equals(gL.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static List<Edit> getEdits(HapPair hapPair, GL gL, Random random) {
        ArrayList<Edit> arrayList = new ArrayList<Edit>();
        int n = hapPair.sampleIndex();
        int n2 = gL.nMarkers();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = hapPair.allele1(i);
            if (!(gL.gl(i, n, n4, n3 = hapPair.allele2(i)) <= 0.0f)) continue;
            int n5 = gL.allele1(i, n);
            int n6 = gL.allele2(i, n);
            if (n5 < 0 || n6 < 0) continue;
            if (!gL.isPhased(i, n) && random.nextBoolean()) {
                int n7 = n5;
                n5 = n6;
                n6 = n7;
            }
            arrayList.add(new Edit(hapPair, i, n5, n6));
        }
        return arrayList;
    }

    private static HapPair updatedHapPair(HapPair hapPair, List<Edit> list, int[] nArray, int[] nArray2) {
        if (list.isEmpty()) {
            return hapPair;
        }
        GenotypeCorrection.copyAlleles(hapPair, nArray, nArray2);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Edit edit = list.get(i);
            nArray[edit.marker()] = edit.newAllele1();
            nArray2[edit.marker()] = edit.newAllele2();
        }
        return new BitHapPair(hapPair.markers(), hapPair.samples(), hapPair.sampleIndex(), nArray, nArray2);
    }

    private static void copyAlleles(HapPair hapPair, int[] nArray, int[] nArray2) {
        assert (hapPair.nMarkers() == nArray.length);
        assert (nArray.length == nArray2.length);
        int n = hapPair.nMarkers();
        for (int i = 0; i < n; ++i) {
            nArray[i] = hapPair.allele1(i);
            nArray2[i] = hapPair.allele2(i);
        }
    }

    private static class Edit {
        private final HapPair hapPair;
        private final int marker;
        private final int newAllele1;
        private final int newAllele2;

        public Edit(HapPair hapPair, int n, int n2, int n3) {
            if (n < 0 || n > hapPair.nMarkers()) {
                throw new IndexOutOfBoundsException("marker=" + n);
            }
            if (n2 < 0 || n2 >= hapPair.marker(n).nAlleles()) {
                throw new IndexOutOfBoundsException("newAllele1=" + n2);
            }
            if (n3 < 0 || n3 >= hapPair.marker(n).nAlleles()) {
                throw new IndexOutOfBoundsException("newAllele2=" + n3);
            }
            this.hapPair = hapPair;
            this.marker = n;
            this.newAllele1 = n2;
            this.newAllele2 = n3;
        }

        public int marker() {
            return this.marker;
        }

        public HapPair hapPair() {
            return this.hapPair;
        }

        public int newAllele1() {
            return this.newAllele1;
        }

        public int newAllele2() {
            return this.newAllele2;
        }

        public String toString() {
            Marker marker = this.hapPair.markers().marker(this.marker);
            String string = this.hapPair.samples().id(this.hapPair.sampleIndex());
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(marker.id());
            stringBuilder.append('\t');
            stringBuilder.append(string);
            int n = marker.nAlleles();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(i < 2 ? (char)'\t' : ',');
                stringBuilder.append(marker.allele(i));
            }
            stringBuilder.append('\t');
            stringBuilder.append(this.newAllele1);
            stringBuilder.append('/');
            stringBuilder.append(this.newAllele2);
            stringBuilder.append('\t');
            stringBuilder.append(this.hapPair.allele1(this.marker));
            stringBuilder.append('/');
            stringBuilder.append(this.hapPair.allele2(this.marker));
            return stringBuilder.toString();
        }
    }
}

