/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.InstanceInformation;
import com.yahoo.labs.samoa.instances.Instances;

public class InstancesHeader
extends Instances {
    private static final long serialVersionUID = 1L;

    public InstancesHeader(Instances i) {
        super(i, 0);
    }

    public InstancesHeader() {
    }

    public static String getClassNameString(InstancesHeader context) {
        if (context == null) {
            return "[class]";
        }
        return "[class:" + context.classAttribute().name() + "]";
    }

    public static String getClassLabelString(InstancesHeader context, int classLabelIndex) {
        if (context == null || classLabelIndex >= context.numClasses()) {
            return "<class " + (classLabelIndex + 1) + ">";
        }
        return "<class " + (classLabelIndex + 1) + ":" + context.classAttribute().value(classLabelIndex) + ">";
    }

    public static String getAttributeNameString(InstancesHeader context, int attIndex) {
        if (context == null || attIndex >= context.numAttributes()) {
            return "[att " + (attIndex + 1) + "]";
        }
        int instAttIndex = attIndex < context.classIndex() ? attIndex : attIndex + 1;
        return "[att " + (attIndex + 1) + ":" + context.attribute(instAttIndex).name() + "]";
    }

    public static String getInputAttributeNameString(InstancesHeader context, int attIndex) {
        if (context == null || attIndex >= context.numInputAttributes()) {
            return "[att " + (attIndex + 1) + "]";
        }
        int instAttIndex = attIndex;
        return "[att " + (attIndex + 1) + ":" + context.inputAttribute(instAttIndex).name() + "]";
    }

    public static String getNominalValueString(InstancesHeader context, int attIndex, int valIndex) {
        if (context != null) {
            int instAttIndex;
            int n = instAttIndex = attIndex < context.classIndex() ? attIndex : attIndex + 1;
            if (instAttIndex < context.numAttributes() && valIndex < context.attribute(instAttIndex).numValues()) {
                return "{val " + (valIndex + 1) + ":" + context.attribute(instAttIndex).value(valIndex) + "}";
            }
        }
        return "{val " + (valIndex + 1) + "}";
    }

    public static String getNumericValueString(InstancesHeader context, int attIndex, double value) {
        if (context != null) {
            int instAttIndex;
            int n = instAttIndex = attIndex < context.classIndex() ? attIndex : attIndex + 1;
            if (instAttIndex < context.numAttributes() && context.attribute(instAttIndex).isDate()) {
                return context.attribute(instAttIndex).formatDate(value);
            }
        }
        return Double.toString(value);
    }

    public Attribute inputAttribute(int w) {
        return this.instanceInformation.inputAttribute(w);
    }

    public Attribute outputAttribute(int w) {
        return this.instanceInformation.outputAttribute(w);
    }

    public int numInputAttributes() {
        return this.instanceInformation.numInputAttributes();
    }

    public int numOutputAttributes() {
        return this.instanceInformation.numOutputAttributes();
    }

    public InstanceInformation getInstanceInformation() {
        return this.instanceInformation;
    }
}

