## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----warning = FALSE, message = FALSE, results = 'hide'-----------------------
# load EAVA package
library(EAVA)
library(stringi)
library(stringr)

# load embedded example data
data <- as.data.frame(data_public)

# run odk2EAVA() using example data
output <- odk2EAVA(data, id_col  = "comsa_id")

# run codEAVA for neonates and children 1-to-59 months of age
EAVA_neonate <- codEAVA(output, "neonate")
EAVA_child <- codEAVA(output, "child")

## ----warning = FALSE, message = FALSE-----------------------------------------
# check results
head(EAVA_neonate)
head(EAVA_child)

