/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.CART;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IAttribute;

public class ResultPrinter {
    private String header;
    private String trainResultFile;
    private String testResultFile;
    private String ModelResultFile;
    private IAttribute outputAttribute;
    private DoubleTransposedDataSet trainData;
    private DoubleTransposedDataSet testData;

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getTrainResultFile() {
        return this.trainResultFile;
    }

    public void setTrainResultFile(String trainResultFile) {
        this.trainResultFile = trainResultFile;
    }

    public String getTestResultFile() {
        return this.testResultFile;
    }

    public void setTestResultFile(String testResultFile) {
        this.testResultFile = testResultFile;
    }

    public String getModelResultFile() {
        return this.ModelResultFile;
    }

    public void setModelResultFile(String modelResultFile) {
        this.ModelResultFile = modelResultFile;
    }

    public IAttribute getOutputAttribute() {
        return this.outputAttribute;
    }

    public void setOutputAttribute(IAttribute outputAttribute) {
        this.outputAttribute = outputAttribute;
    }

    public DoubleTransposedDataSet getTrainData() {
        return this.trainData;
    }

    public void setTrainData(DoubleTransposedDataSet trainData) {
        this.trainData = trainData;
    }

    public DoubleTransposedDataSet getTestData() {
        return this.testData;
    }

    public void setTestData(DoubleTransposedDataSet testData) {
        this.testData = testData;
    }

    public void writeResults(byte[][] predictedTrain, byte[][] predictedTest) {
        try {
            int predictedClass;
            int observedClass;
            int i;
            PrintWriter print = new PrintWriter(new FileWriter(this.trainResultFile));
            print.write(this.header);
            double[][] observedOutputs = this.trainData.getAllOutputs();
            for (i = 0; i < this.trainData.getNofobservations(); ++i) {
                observedClass = 1;
                while (observedOutputs[observedClass - 1][i] != 1.0) {
                    ++observedClass;
                }
                print.write(this.outputAttribute.show(observedClass) + " ");
                predictedClass = 1;
                while (predictedTrain[predictedClass - 1][i] != 1) {
                    ++predictedClass;
                }
                print.write(this.outputAttribute.show(predictedClass) + "\n");
            }
            print.close();
            print = new PrintWriter(new FileWriter(this.testResultFile));
            print.write(this.header);
            observedOutputs = this.testData.getAllOutputs();
            for (i = 0; i < this.testData.getNofobservations(); ++i) {
                observedClass = 1;
                while (observedOutputs[observedClass - 1][i] != 1.0) {
                    ++observedClass;
                }
                print.write(this.outputAttribute.show(observedClass) + " ");
                predictedClass = 1;
                while (predictedTest[predictedClass - 1][i] != 1) {
                    ++predictedClass;
                }
                print.write(this.outputAttribute.show(predictedClass) + "\n");
            }
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    public void writeResults(double[] predictedTrain, double[] predictedTest) {
        try {
            double predictedClass;
            double observedClass;
            int i;
            PrintWriter print = new PrintWriter(new FileWriter(this.trainResultFile));
            print.write(this.header);
            double[] observedOutputs = this.trainData.getAllOutputs()[0];
            for (i = 0; i < this.trainData.getNofobservations(); ++i) {
                observedClass = observedOutputs[i];
                print.write(this.outputAttribute.show(observedClass) + " ");
                predictedClass = predictedTrain[i];
                print.write(this.outputAttribute.show(predictedClass) + "\n");
            }
            print.close();
            print = new PrintWriter(new FileWriter(this.testResultFile));
            print.write(this.header);
            observedOutputs = this.testData.getAllOutputs()[0];
            for (i = 0; i < this.testData.getNofobservations(); ++i) {
                observedClass = observedOutputs[i];
                print.write(this.outputAttribute.show(observedClass) + " ");
                predictedClass = predictedTest[i];
                print.write(this.outputAttribute.show(predictedClass) + "\n");
            }
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    public void printModelFile(Object result) {
        try {
            PrintWriter print = new PrintWriter(new FileWriter(this.ModelResultFile));
            print.write(result.toString());
            print.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

