/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree.mut;

import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.IMutateExprTree;
import net.sourceforge.jclec.util.random.IRandGen;

public class SubtreeMutator
implements IMutateExprTree {
    private static final long serialVersionUID = -3347565776071085624L;

    public boolean equals(Object other) {
        return other instanceof SubtreeMutator;
    }

    @Override
    public ExprTree mutateExprTree(ExprTree ptree, ExprTreeSchema schema, IRandGen randgen) {
        ExprTree stree = new ExprTree();
        int size = ptree.size();
        int startIndex = randgen.choose(1, size);
        int endIndex = ptree.subTree(startIndex);
        int i = 0;
        while (i < startIndex) {
            stree.addBlock(ptree.getBlock(i).copy());
            ++i;
        }
        int new_size = size - (endIndex - startIndex);
        int branchSize = randgen.choose(0, schema.getMaxTreeSize() - new_size);
        if (branchSize == 0) {
            branchSize = 1;
        }
        Class<?> rtype = ptree.getBlock(startIndex).returnType();
        schema.fillExprBranch(stree, rtype, branchSize, randgen);
        int i2 = endIndex;
        while (i2 < size) {
            stree.addBlock(ptree.getBlock(i2).copy());
            ++i2;
        }
        return stree;
    }
}

