/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.core.Instance;
import weka.core.Utils;

public class HTML
extends AbstractOutput {
    private static final long serialVersionUID = 7241252244954353300L;

    @Override
    public String globalInfo() {
        return "Outputs the predictions in HTML.";
    }

    @Override
    public String getDisplay() {
        return "HTML";
    }

    protected String sanitize(String s) {
        String result = s;
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\"", "&quot;");
        return result;
    }

    @Override
    protected void doPrintHeader() {
        this.append("<html>\n");
        this.append("<head>\n");
        this.append("<title>Predictions for dataset " + this.sanitize(this.m_Header.relationName()) + "</title>\n");
        this.append("</head>\n");
        this.append("<body>\n");
        this.append("<div align=\"center\">\n");
        this.append("<h3>Predictions for dataset " + this.sanitize(this.m_Header.relationName()) + "</h3>\n");
        this.append("<table border=\"1\">\n");
        this.append("<tr>\n");
        if (this.m_Header.classAttribute().isNominal()) {
            if (this.m_OutputDistribution) {
                this.append("<td>inst#</td><td>actual</td><td>predicted</td><td>error</td><td colspan=\"" + this.m_Header.classAttribute().numValues() + "\">distribution</td>");
            } else {
                this.append("<td>inst#</td><td>actual</td><td>predicted</td><td>error</td><td>prediction</td>");
            }
        } else {
            this.append("<td>inst#</td><td>actual</td><td>predicted</td><td>error</td>");
        }
        if (this.m_Attributes != null) {
            this.append("<td>");
            boolean first = true;
            for (int i = 0; i < this.m_Header.numAttributes(); ++i) {
                if (i == this.m_Header.classIndex() || !this.m_Attributes.isInRange(i)) continue;
                if (!first) {
                    this.append("</td><td>");
                }
                this.append(this.sanitize(this.m_Header.attribute(i).name()));
                first = false;
            }
            this.append("</td>");
        }
        this.append("</tr>\n");
    }

    protected String attributeValuesString(Instance instance) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attributes != null) {
            boolean firstOutput = true;
            this.m_Attributes.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!this.m_Attributes.isInRange(i) || i == instance.classIndex()) continue;
                if (!firstOutput) {
                    text.append("</td>");
                }
                if (this.m_Header.attribute(i).isNumeric()) {
                    text.append("<td align=\"right\">");
                } else {
                    text.append("<td>");
                }
                text.append(this.sanitize(instance.toString(i)));
                firstOutput = false;
            }
            if (!firstOutput) {
                text.append("</td>");
            }
        }
        return text.toString();
    }

    @Override
    protected void doPrintClassification(double[] dist, Instance inst, int index) throws Exception {
        int prec = this.m_NumDecimals;
        Instance withMissing = (Instance)inst.copy();
        withMissing.setDataset(inst.dataset());
        double predValue = 0.0;
        predValue = Utils.sum(dist) == 0.0 ? Utils.missingValue() : (inst.classAttribute().isNominal() ? (double)Utils.maxIndex(dist) : dist[0]);
        this.append("<tr>");
        this.append("<td>" + (index + 1) + "</td>");
        if (inst.dataset().classAttribute().isNumeric()) {
            if (inst.classIsMissing()) {
                this.append("<td align=\"right\">?</td>");
            } else {
                this.append("<td align=\"right\">" + Utils.doubleToString(inst.classValue(), prec) + "</td>");
            }
            if (Utils.isMissingValue(predValue)) {
                this.append("<td align=\"right\">?</td>");
            } else {
                this.append("<td align=\"right\">" + Utils.doubleToString(predValue, prec) + "</td>");
            }
            if (Utils.isMissingValue(predValue) || inst.classIsMissing()) {
                this.append("<td align=\"right\">?</td>");
            } else {
                this.append("<td align=\"right\">" + Utils.doubleToString(predValue - inst.classValue(), prec) + "</td>");
            }
        } else {
            this.append("<td>" + ((int)inst.classValue() + 1) + ":" + this.sanitize(inst.toString(inst.classIndex())) + "</td>");
            if (Utils.isMissingValue(predValue)) {
                this.append("<td>?</td>");
            } else {
                this.append("<td>" + ((int)predValue + 1) + ":" + this.sanitize(inst.dataset().classAttribute().value((int)predValue)) + "</td>");
            }
            if (!Utils.isMissingValue(predValue) && !inst.classIsMissing() && (int)predValue + 1 != (int)inst.classValue() + 1) {
                this.append("<td>+</td>");
            } else {
                this.append("<td>&nbsp;</td>");
            }
            if (this.m_OutputDistribution) {
                if (Utils.isMissingValue(predValue)) {
                    this.append("<td>?</td>");
                } else {
                    this.append("<td align=\"right\">");
                    for (int n = 0; n < dist.length; ++n) {
                        if (n > 0) {
                            this.append("</td><td align=\"right\">");
                        }
                        if (n == (int)predValue) {
                            this.append("*");
                        }
                        this.append(Utils.doubleToString(dist[n], prec));
                    }
                    this.append("</td>");
                }
            } else if (Utils.isMissingValue(predValue)) {
                this.append("<td align=\"right\">?</td>");
            } else {
                this.append("<td align=\"right\">" + Utils.doubleToString(dist[(int)predValue], prec) + "</td>");
            }
        }
        this.append(this.attributeValuesString(withMissing) + "</tr>\n");
    }

    @Override
    protected void doPrintClassification(Classifier classifier, Instance inst, int index) throws Exception {
        double[] d = classifier.distributionForInstance(inst);
        this.doPrintClassification(d, inst, index);
    }

    @Override
    protected void doPrintFooter() {
        this.append("</table>\n");
        this.append("</div>\n");
        this.append("</body>\n");
        this.append("</html>\n");
    }
}

