/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.swing.TableHeaderCellRenderer;
import com.qarks.util.ui.swing.file_chooser.ADirectoryParser;
import com.qarks.util.ui.swing.file_chooser.DefaultFileView;
import com.qarks.util.ui.swing.file_chooser.DirectoryParser;
import com.qarks.util.ui.swing.file_chooser.FileInfos;
import com.qarks.util.ui.swing.file_chooser.FileSelectionListener;
import com.qarks.util.ui.swing.file_chooser.FileSystemParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.io.File;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.JTableHeader;

public class FileChooser
extends JPanel {
    private JScrollPane mLeftScrollPane = null;
    private JScrollPane mRightScrollPane = null;
    private JSplitPane mSplitPane = null;
    private FileSystemParser mFileSystemParser = null;
    private DirectoryParser mDirectoryParser = null;
    private Vector mFileSelectionListeners = new Vector();
    private ListSelectionListener mFileSelListener = null;

    public FileChooser() {
        this.setFont(new Font("SansSerif", 1, 12));
        DefaultFileView defaultFileView = new DefaultFileView();
        this.mDirectoryParser = new DirectoryParser(defaultFileView);
        this.mFileSystemParser = new FileSystemParser(FileSystemView.getFileSystemView(), defaultFileView, this.mDirectoryParser);
        this.mDirectoryParser.setFileSystemParser(this.mFileSystemParser);
        this.mLeftScrollPane = new JScrollPane(this.mFileSystemParser){

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 200;
                return dimension;
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.mDirectoryParser, "Center");
        jPanel.setOpaque(false);
        this.mRightScrollPane = new JScrollPane(jPanel);
        JTableHeader jTableHeader = this.mDirectoryParser.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new TableHeaderCellRenderer());
        this.mRightScrollPane.setColumnHeaderView(jTableHeader);
        this.mSplitPane = new JSplitPane(1, this.mLeftScrollPane, this.mRightScrollPane);
        this.mLeftScrollPane.setBackground(Color.white);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.mSplitPane);
        this.mFileSystemParser.setBackground(Color.white);
    }

    public void setMultipleSelection(boolean bl) {
        this.mDirectoryParser.setMultipleSelection(bl);
    }

    public ADirectoryParser getDirectoryParser() {
        return this.mDirectoryParser;
    }

    public boolean currentDirContainsFile(String string) {
        return this.mDirectoryParser.currentDirContainsFile(string);
    }

    public void addFileSelectionListener(FileSelectionListener fileSelectionListener) {
        this.mFileSelectionListeners.addElement(fileSelectionListener);
        if (this.mFileSelListener == null) {
            this.mFileSelListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    File[] fileArray = FileChooser.this.mDirectoryParser.getSelectedFiles();
                    for (int i = 0; i < FileChooser.this.mFileSelectionListeners.size(); ++i) {
                        FileSelectionListener fileSelectionListener = (FileSelectionListener)FileChooser.this.mFileSelectionListeners.elementAt(i);
                        fileSelectionListener.onFileSelected(fileArray);
                    }
                }
            };
            this.mDirectoryParser.addFileSelectionListener(this.mFileSelListener);
        }
    }

    public void removeFileSelectionListener(FileSelectionListener fileSelectionListener) {
        this.mFileSelectionListeners.removeElement(fileSelectionListener);
    }

    public void setHeaderFont(Font font) {
        JTableHeader jTableHeader = this.mDirectoryParser.getTableHeader();
        TableHeaderCellRenderer tableHeaderCellRenderer = (TableHeaderCellRenderer)jTableHeader.getDefaultRenderer();
        tableHeaderCellRenderer.setFont(font);
    }

    public void setCellInterSpacing(Dimension dimension) {
        this.mDirectoryParser.setIntercellSpacing(dimension);
    }

    public void setHeaderColor(Color color) {
        JTableHeader jTableHeader = this.mDirectoryParser.getTableHeader();
        TableHeaderCellRenderer tableHeaderCellRenderer = (TableHeaderCellRenderer)jTableHeader.getDefaultRenderer();
        tableHeaderCellRenderer.setBackground(color);
    }

    public void setFilter(String[] stringArray) {
        this.mDirectoryParser.setFilter(stringArray);
    }

    public void clearFileSelection() {
        int n = this.mDirectoryParser.getRowCount();
        this.mDirectoryParser.getSelectionModel().removeSelectionInterval(0, n - 1);
    }

    public int getSplitPosition() {
        return this.mSplitPane.getDividerLocation();
    }

    public void setSplitPosition(int n) {
        this.mSplitPane.setDividerLocation(n);
    }

    public void setCurrentDir(String string) {
        this.mFileSystemParser.setWorking(true);
        this.mFileSystemParser.setCurrentDirectory(string);
        Point point = this.mFileSystemParser.getSelectedItemPosition();
        JViewport jViewport = this.mLeftScrollPane.getViewport();
        jViewport.setViewPosition(point);
        this.mFileSystemParser.setWorking(false);
    }

    public String getCurrentDirectory() {
        return this.mFileSystemParser.getCurrentDirectory();
    }

    public Object[] getSelectedItems() {
        int[] nArray = this.mDirectoryParser.getSelectedRows();
        Object[] objectArray = new File[nArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            FileInfos fileInfos = (FileInfos)this.mDirectoryParser.getValueAt(nArray[i], 0);
            objectArray[i] = fileInfos.getFile();
        }
        return objectArray;
    }

    public File[] getSelectedFiles() {
        return (File[])this.getSelectedItems();
    }

    public void refreshDirectoryContent() {
        if (this.mDirectoryParser.getCurrentDirectory() == null) {
            this.mDirectoryParser.setCurrentDirectory(new File(this.mFileSystemParser.getCurrentDirectory()));
        } else {
            this.mDirectoryParser.refreshCurrentDirectory();
        }
    }

    public void refresh() {
        this.mFileSystemParser.refresh();
    }
}

