/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import eu.kliegr.ac1.BaseConfig;
import eu.kliegr.ac1.rule.TestingType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Logger;

public class TestConfig
extends BaseConfig {
    private static final Logger LOGGER = Logger.getLogger(TestConfig.class.getName());
    private String rulesPath = "/home/tomas/NetBeansProjects/AC1/resources/Iris1_iris_1_0.5.xml";
    private String testRuleSortComparator = "CBARuleComparator";
    private Comparator ruleComparator;
    private TestingType testingType;

    public TestConfig() {
    }

    public TestConfig(String path) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        this.rulesPath = prop.getProperty("RulesPath");
        this.setOutputPath(prop.getProperty("OutputPath"));
        this.dataPath = prop.getProperty("TestDataPath");
        String _attprune = prop.getProperty("AttributePruning");
        String _testRuleSortComparator = prop.getProperty("TestRuleSortComparator");
        if (_testRuleSortComparator != null) {
            this.testRuleSortComparator = _testRuleSortComparator;
        }
        this.ruleComparator = (Comparator)Class.forName("eu.kliegr.ac1.rule." + this.testRuleSortComparator).newInstance();
        this.csvSeparator = prop.getProperty("DataTypes").contains(";") ? ";" : ",";
        this.attType = this.parseAttributeTypes(prop.getProperty("DataTypes").split(this.csvSeparator));
        this.IDcolumnName = prop.getProperty("IDcolumnName");
        this.targetAttribute = prop.getProperty("TargetAttribute");
        this.testingType = TestingType.valueOf(prop.getProperty("TestingType"));
    }

    public Comparator getRuleComparator() {
        return this.ruleComparator;
    }

    public String getRulesPath() {
        return this.rulesPath;
    }

    public String getOutputSummaryPath() {
        return this.getOutputPath("summary");
    }

    public TestingType getTestingType() {
        return this.testingType;
    }
}

