/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.SparseArray;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="INT-SparseArray", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"indices", "entries"})
@JsonRootName(value="INT-SparseArray")
@JsonPropertyOrder(value={"n", "defaultValue", "indices", "entries"})
public class IntSparseArray
extends SparseArray<Integer> {
    @XmlAttribute(name="n")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="n")
    private Integer n;
    @XmlAttribute(name="defaultValue")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="defaultValue")
    private Integer defaultValue;
    @XmlList
    @XmlElement(name="Indices", namespace="http://www.dmg.org/PMML-4_4", type=Integer.class)
    @JsonProperty(value="Indices")
    private List<Integer> indices;
    @XmlList
    @XmlElement(name="INT-Entries", namespace="http://www.dmg.org/PMML-4_4", type=Integer.class)
    @JsonProperty(value="INT-Entries")
    private List<Integer> entries;
    private static final Integer DEFAULT_DEFAULT_VALUE = new IntegerAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371272L;

    @Override
    public Integer getN() {
        return this.n;
    }

    public IntSparseArray setN(@Property(value="n") Integer n) {
        this.n = n;
        return this;
    }

    @Override
    public Integer getDefaultValue() {
        if (this.defaultValue == null) {
            return DEFAULT_DEFAULT_VALUE;
        }
        return this.defaultValue;
    }

    public IntSparseArray setDefaultValue(@Property(value="defaultValue") Integer defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public boolean hasIndices() {
        return this.indices != null && !this.indices.isEmpty();
    }

    @Override
    public List<Integer> getIndices() {
        if (this.indices == null) {
            this.indices = new ArrayList<Integer>();
        }
        return this.indices;
    }

    public IntSparseArray addIndices(Integer ... indices) {
        this.getIndices().addAll(Arrays.asList(indices));
        return this;
    }

    @Override
    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    @Override
    public List<Integer> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<Integer>();
        }
        return this.entries;
    }

    public IntSparseArray addEntries(Integer ... entries) {
        this.getEntries().addAll(Arrays.asList(entries));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

