/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.restopt.choco.ConnectivityFinderSpatialGraph;

public class PropNoNewCC
extends Propagator<UndirectedGraphVar> {
    private final UndirectedGraphVar g;
    private final ISet LBNodes;
    private ConnectivityFinderSpatialGraph ccUB;

    public PropNoNewCC(UndirectedGraphVar g) {
        super((Variable[])new UndirectedGraphVar[]{g}, (Priority)PropagatorPriority.QUADRATIC, false);
        this.g = g;
        this.ccUB = new ConnectivityFinderSpatialGraph((UndirectedGraph)g.getUB());
        this.LBNodes = SetFactory.makeConstantSet(g.getMandatoryNodes().toArray());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.ccUB.findAllCC();
        ISet ccOfOrignalLB = SetFactory.makeRangeSet();
        ISetIterator iSetIterator = this.LBNodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ccOfOrignalLB.add(this.ccUB.getNodeCC()[i]);
        }
        iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int node = (Integer)iSetIterator.next();
            if (ccOfOrignalLB.contains(this.ccUB.getNodeCC()[node])) continue;
            this.g.removeNode(node, this);
        }
    }

    @Override
    public ESat isEntailed() {
        this.ccUB.findAllCC();
        ISet ccOfOrignalLB = SetFactory.makeRangeSet();
        ISetIterator iSetIterator = this.LBNodes.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ccOfOrignalLB.add(this.ccUB.getNodeCC()[i]);
        }
        iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int node = (Integer)iSetIterator.next();
            if (!this.g.getMandatoryNodes().contains(node) || ccOfOrignalLB.contains(this.ccUB.getNodeCC()[node])) continue;
            return ESat.FALSE;
        }
        if (!this.g.isInstantiated()) {
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }
}

