/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.trace.SearchViz;

public class GephiGenerator
extends SearchViz {
    private final String instance;
    private final StringBuilder nodes;
    private final StringBuilder edges;
    private int nodeCount;
    private int edgeCount;

    public GephiGenerator(String gexfFile, Solver aSolver) {
        super(aSolver, false);
        this.instance = gexfFile;
        this.nodes = new StringBuilder();
        this.edges = new StringBuilder();
    }

    @Override
    protected void disconnect() {
        Path file = Paths.get(this.instance, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Files.createFile(file, new FileAttribute[0]);
            Files.write(file, "<?xml version=\"1.0\" encoding=\"UTF\u22128\"?>\n<gexf \txmlns=\"http://www.gexf.net/1.2draft\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema\u2212instance\"\n\txsi:schemaLocation=\"http://www.gexf.net/1.2draft\n\t\thttp://www.gexf.net/1.2draft/gexf.xsd\"\n\txmlns:viz=\"http://www.gexf.net/1.2draft/viz\"\n\tversion=\"1.2\">\n".getBytes(), StandardOpenOption.WRITE);
            Files.write(file, "\t<graph mode=\"static\" defaultedgetype=\"directed\">\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, String.format("\t\t<nodes count=\"%d\">\n", this.nodeCount).getBytes(), StandardOpenOption.APPEND);
            Files.write(file, this.nodes.toString().getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t\t</nodes>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t\t<edges>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, this.edges.toString().getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t\t</edges>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "\t</graph>\n".getBytes(), StandardOpenOption.APPEND);
            Files.write(file, "</gexf>\n".getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Unable to write to GEXF file. No information will be sent.");
        }
    }

    @Override
    protected void sendNode(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        ++this.nodeCount;
        if (pid == -1) {
            this.nodes.append(String.format("\t\t\t<node id=\"%d\" label=\"%s\">\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", nc, label, "<viz:color r=\"191\" g=\"127\" b=\"63\" a=\"1\"/>", "<viz:shape value=\"disc\"/>"));
        } else {
            this.nodes.append(String.format("\t\t\t<node id=\"%s\" label=\"%s\" %s>\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", nc, label, String.format("pid=\"%s\"", pid), "<viz:color r=\"63\" g=\"127\" b=\"191\" a=\"0.1\"/>", "<viz:shape value=\"disc\"/>"));
            this.edges.append(String.format("\t\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" type=\"directed\"/>\n", this.edgeCount++, pid, nc));
        }
    }

    @Override
    protected void sendSolution(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        ++this.nodeCount;
        this.nodes.append(String.format("\t\t\t<node id=\"%s\" label=\"%s\" %s>\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", nc, label, String.format("pid=\"%s\"", pid), "<viz:color r=\"63\" g=\"191\" b=\"63\" a=\"1\"/>", "<viz:shape value=\"disc\"/>"));
        this.edges.append(String.format("\t\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" type=\"directed\"/>\n", this.edgeCount++, pid, nc));
    }

    @Override
    protected void sendFailure(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        ++this.nodeCount;
        this.nodes.append(String.format("\t\t\t<node id=\"%s\" label=\"%s\" %s>\n\t\t\t\t%s\n\t\t\t\t%s\n\t\t\t</node>\n", nc, label, String.format("pid=\"%s\"", pid), "<viz:color r=\"191\" g=\"63\" b=\"63\" a=\"1\"/>", "<viz:shape value=\"disc\"/>"));
        this.edges.append(String.format("\t\t\t<edge id=\"%s\" source=\"%s\" target=\"%s\" type=\"directed\"/>\n", this.edgeCount++, pid, nc));
    }

    @Override
    protected void sendRestart(int rid) {
    }
}

